/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.services;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.services.MavenRepositoryService;
import org.jetbrains.idea.maven.services.artifactory.ArtifactoryRepositoryService;
import org.jetbrains.idea.maven.services.nexus.NexusRepositoryService;
import org.jetbrains.idea.maven.utils.MavenLog;

@State(name="MavenServices", storages={@Storage(file="$APP_CONFIG$/mavenServices.xml")})
public class MavenRepositoryServicesManager
implements PersistentStateComponent<MavenRepositoryServicesManager> {
    private final List<String> myUrls = new ArrayList<String>();

    public MavenRepositoryServicesManager() {
        this.myUrls.add("http://oss.sonatype.org/service/local/");
        this.myUrls.add("http://repo.jfrog.org/artifactory/api/");
        this.myUrls.add("https://repository.jboss.org/nexus/service/local/");
    }

    @NotNull
    public static MavenRepositoryServicesManager getInstance() {
        MavenRepositoryServicesManager mavenRepositoryServicesManager = (MavenRepositoryServicesManager)ServiceManager.getService(MavenRepositoryServicesManager.class);
        if (mavenRepositoryServicesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "getInstance"));
        }
        return mavenRepositoryServicesManager;
    }

    @NotNull
    public static MavenRepositoryService[] getServices() {
        MavenRepositoryService[] mavenRepositoryServiceArray = new MavenRepositoryService[]{new NexusRepositoryService(), new ArtifactoryRepositoryService()};
        if (mavenRepositoryServiceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "getServices"));
        }
        return mavenRepositoryServiceArray;
    }

    public static String[] getServiceUrls() {
        return ArrayUtil.toStringArray(MavenRepositoryServicesManager.getInstance().getUrls());
    }

    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="service-url", elementValueAttribute="")
    @NotNull
    public List<String> getUrls() {
        List<String> list = this.myUrls;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "getUrls"));
        }
        return list;
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "setUrls"));
        }
        if (this.myUrls != urls) {
            this.myUrls.clear();
            this.myUrls.addAll(urls);
        }
    }

    public MavenRepositoryServicesManager getState() {
        return this;
    }

    public void loadState(MavenRepositoryServicesManager state) {
        this.myUrls.clear();
        this.myUrls.addAll(state.getUrls());
    }

    @NotNull
    public static List<MavenRepositoryInfo> getRepositories(String url) {
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.getRepositories(url));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "getRepositories"));
        }
        return smartList;
    }

    @NotNull
    public static List<MavenArtifactInfo> findArtifacts(@NotNull MavenArtifactInfo template, @NotNull String url) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.findArtifacts(url, template));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        return smartList;
    }
}

