/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;

public class MavenArtifactSearcher
extends MavenSearcher<MavenArtifactSearchResult> {
    public static final String TERM = "u";

    @Override
    protected Pair<String, Query> preparePatternAndQuery(String pattern) {
        if ((pattern = pattern.toLowerCase()).trim().length() == 0) {
            return Pair.create((Object)pattern, (Object)new MatchAllDocsQuery());
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (String each : StringUtil.tokenize((String)pattern, (String)" :")) {
            parts.add(each);
        }
        BooleanQuery query = new BooleanQuery();
        if (parts.size() == 1) {
            query.add((Query)new WildcardQuery(new Term(TERM, "*" + (String)parts.get(0) + "*|*|*|*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(TERM, "*|*" + (String)parts.get(0) + "*|*|*")), BooleanClause.Occur.SHOULD);
        }
        if (parts.size() == 2) {
            query.add((Query)new WildcardQuery(new Term(TERM, "*" + (String)parts.get(0) + "*|*" + (String)parts.get(1) + "*|*|*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(TERM, "*" + (String)parts.get(0) + "*|*|" + (String)parts.get(1) + "*|*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(TERM, "*|*" + (String)parts.get(0) + "*|" + (String)parts.get(1) + "*|*")), BooleanClause.Occur.SHOULD);
        }
        if (parts.size() >= 3) {
            String s = "*" + (String)parts.get(0) + "*|*" + (String)parts.get(1) + "*|" + (String)parts.get(2) + "*|*";
            query.add((Query)new WildcardQuery(new Term(TERM, s)), BooleanClause.Occur.MUST);
        }
        return Pair.create((Object)pattern, (Object)query);
    }

    @Override
    protected Collection<MavenArtifactSearchResult> processResults(Set<MavenArtifactInfo> infos, String pattern, int maxResult) {
        THashMap result = new THashMap();
        for (MavenArtifactInfo each : infos) {
            if (!StringUtil.isEmptyOrSpaces((String)each.getClassifier())) continue;
            String key = this.makeKey(each);
            MavenArtifactSearchResult searchResult = (MavenArtifactSearchResult)result.get(key);
            if (searchResult == null) {
                searchResult = new MavenArtifactSearchResult();
                result.put(key, searchResult);
            }
            searchResult.versions.add(each);
        }
        return result.values();
    }
}

