/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.roots.ui.configuration.artifacts.ManifestFilesInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactExternalDependenciesImporter {
    private final ManifestFilesInfo myManifestFiles = new ManifestFilesInfo();
    private final Map<Artifact, List<PackagingElement<?>>> myExternalDependencies = new HashMap();

    @Nullable
    public ManifestFileConfiguration getManifestFile(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/idea/maven/importing/ArtifactExternalDependenciesImporter", "getManifestFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/importing/ArtifactExternalDependenciesImporter", "getManifestFile"));
        }
        return this.myManifestFiles.getManifestFile(artifact.getRootElement(), artifact.getArtifactType(), context);
    }

    public List<PackagingElement<?>> getExternalDependenciesList(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/idea/maven/importing/ArtifactExternalDependenciesImporter", "getExternalDependenciesList"));
        }
        List<PackagingElement<?>> elements = this.myExternalDependencies.get(artifact);
        if (elements == null) {
            elements = new ArrayList();
            this.myExternalDependencies.put(artifact, elements);
        }
        return elements;
    }

    public void applyChanges(ModifiableArtifactModel artifactModel, final PackagingElementResolvingContext context) {
        this.myManifestFiles.saveManifestFiles();
        final ArrayList elementsToInclude = new ArrayList();
        for (Artifact artifact : artifactModel.getArtifacts()) {
            ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)ArtifactElementType.ARTIFACT_ELEMENT_TYPE, (PackagingElementProcessor)new PackagingElementProcessor<ArtifactPackagingElement>(){

                public boolean process(@NotNull ArtifactPackagingElement artifactPackagingElement, @NotNull PackagingElementPath path) {
                    List elements;
                    if (artifactPackagingElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPackagingElement", "org/jetbrains/idea/maven/importing/ArtifactExternalDependenciesImporter$1", "process"));
                    }
                    if (path == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/maven/importing/ArtifactExternalDependenciesImporter$1", "process"));
                    }
                    Artifact included = artifactPackagingElement.findArtifact(context);
                    CompositePackagingElement parent = path.getLastParent();
                    if (parent != null && included != null && (elements = (List)ArtifactExternalDependenciesImporter.this.myExternalDependencies.get(included)) != null) {
                        elementsToInclude.add(Pair.create((Object)parent, (Object)elements));
                    }
                    return true;
                }
            }, (PackagingElementResolvingContext)context, (boolean)false);
        }
        for (Pair pair : elementsToInclude) {
            ((CompositePackagingElement)pair.getFirst()).addOrFindChildren((Collection)pair.getSecond());
        }
    }
}

