/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.model.MavenDomArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;

public class MavenDependencyCompletionUtil {
    public static MavenDomDependency findManagedDependency(MavenDomProjectModel domModel, Project project, final @NotNull String groupId, final @NotNull String artifactId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil", "findManagedDependency"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil", "findManagedDependency"));
        }
        final Ref ref = new Ref();
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(domModel, new Processor<MavenDomDependency>(){

            public boolean process(MavenDomDependency dependency) {
                if (groupId.equals(dependency.getGroupId().getStringValue()) && artifactId.equals(dependency.getArtifactId().getStringValue())) {
                    ref.set((Object)dependency);
                    return true;
                }
                return false;
            }
        }, project);
        return (MavenDomDependency)ref.get();
    }

    private static boolean isInsideManagedDependency(MavenDomArtifactCoordinates dependency) {
        DomElement parent = dependency.getParent();
        if (!(parent instanceof MavenDomDependencies)) {
            return false;
        }
        return parent.getParent() instanceof MavenDomDependencyManagement;
    }

    public static void addTypeAndClassifierAndVersion(@NotNull InsertionContext context, @NotNull MavenDomDependency dependency, @NotNull String groupId, @NotNull String artifactId) {
        MavenDomProjectModel model;
        MavenDomDependency managedDependency;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil", "addTypeAndClassifierAndVersion"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil", "addTypeAndClassifierAndVersion"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil", "addTypeAndClassifierAndVersion"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil", "addTypeAndClassifierAndVersion"));
        }
        if (!StringUtil.isEmpty((String)dependency.getVersion().getStringValue())) {
            return;
        }
        Project project = context.getProject();
        if (!MavenDependencyCompletionUtil.isInsideManagedDependency(dependency) && (managedDependency = MavenDependencyCompletionUtil.findManagedDependency(model = (MavenDomProjectModel)DomUtil.getFileElement((DomElement)dependency).getRootElement(), project, groupId, artifactId)) != null) {
            if (dependency.getClassifier().getXmlTag() == null && dependency.getType().getXmlTag() == null) {
                String type;
                String classifier = managedDependency.getClassifier().getRawText();
                if (StringUtil.isNotEmpty((String)classifier)) {
                    dependency.getClassifier().setStringValue(classifier);
                }
                if (StringUtil.isNotEmpty((String)(type = managedDependency.getType().getRawText()))) {
                    dependency.getType().setStringValue(type);
                }
            }
            return;
        }
        MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(project);
        Set<String> versions = manager.getVersions(groupId, artifactId);
        if (versions.size() == 1) {
            dependency.getVersion().setStringValue((String)ContainerUtil.getFirstItem(versions));
            return;
        }
        dependency.getVersion().setStringValue("");
        int versionPosition = dependency.getVersion().getXmlTag().getValue().getTextRange().getStartOffset();
        context.getEditor().getCaretModel().moveToOffset(versionPosition);
        if (versions.size() > 0) {
            MavenDependencyCompletionUtil.invokeCompletion(context, CompletionType.BASIC);
        }
    }

    public static void invokeCompletion(final @NotNull InsertionContext context, final CompletionType completionType) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil", "invokeCompletion"));
        }
        context.setLaterRunnable(new Runnable(){

            @Override
            public void run() {
                new CodeCompletionHandlerBase(completionType).invokeCompletion(context.getProject(), context.getEditor());
            }
        });
    }
}

