/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.model;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.ui.model.SpecialNode;
import com.intellij.execution.junit2.ui.model.TestProxyDescriptor;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.testframework.Filter;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import org.jetbrains.annotations.NotNull;

class TestTreeStructure
extends AbstractTreeStructure {
    private final TestProxy myRootTest;
    private final JUnitConsoleProperties myProperties;
    private SpecialNode mySpecialNode;
    private Filter myFilter = Filter.NO_FILTER;

    public void setFilter(Filter filter) {
        this.myFilter = filter;
    }

    public Filter getFilter() {
        return this.myFilter;
    }

    public TestTreeStructure(TestProxy rootTest, JUnitConsoleProperties properties) {
        this.myRootTest = rootTest;
        this.myProperties = properties;
    }

    public void setSpecialNode(SpecialNode specialNode) {
        this.mySpecialNode = specialNode;
    }

    public Object getRootElement() {
        return this.myRootTest;
    }

    public Object[] getChildElements(Object element) {
        TestProxy[] children = ((TestProxy)((Object)element)).selectChildren(this.myFilter);
        if (element == this.myRootTest) {
            if (children.length == 0 && this.myRootTest.getState().isPassed()) {
                this.mySpecialNode.setVisible(true);
                return this.mySpecialNode.asArray();
            }
            this.mySpecialNode.setVisible(false);
        }
        return children;
    }

    public Object getParentElement(Object element) {
        TestProxy testProxy = (TestProxy)((Object)element);
        return testProxy.getParent();
    }

    @NotNull
    public TestProxyDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        TestProxy testProxy = (TestProxy)((Object)element);
        TestProxyDescriptor testProxyDescriptor = new TestProxyDescriptor(this.myProperties.getProject(), parentDescriptor, testProxy);
        if (testProxyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit2/ui/model/TestTreeStructure", "createDescriptor"));
        }
        return testProxyDescriptor;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }
}

