/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.info.ClassBasedInfo;
import com.intellij.execution.junit2.info.DisplayTestInfoExtractor;
import com.intellij.execution.junit2.segments.InputObjectRegistry;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.execution.junit2.segments.OutputPacketProcessor;
import com.intellij.execution.junit2.states.ComparisonFailureState;
import com.intellij.execution.junit2.states.FaultyState;
import com.intellij.execution.junit2.states.IgnoredState;
import com.intellij.execution.junit2.states.NotFailedState;
import com.intellij.execution.junit2.states.ReadableState;
import com.intellij.execution.junit2.states.SkippedState;
import com.intellij.execution.junit2.states.Statistics;
import com.intellij.execution.junit2.states.SuiteState;
import com.intellij.execution.junit2.states.TestState;
import com.intellij.execution.junit2.states.TestStateUpdater;
import com.intellij.execution.junit2.ui.JUnitTreeConsoleView;
import com.intellij.execution.junit2.ui.model.CompletionEvent;
import com.intellij.execution.junit2.ui.model.JUnitListenersNotifier;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.TestStatusListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsPacketsReceiver
implements OutputPacketProcessor,
Disposable {
    private static final TIntObjectHashMap<StateChanger> STATE_CLASSES = new TIntObjectHashMap();
    private Map<String, TestProxy> myKnownDynamicParents;
    private final TestProxy myUnboundOutput;
    private final InputObjectRegistry myObjectRegistry;
    private final Set<TestProxy> myCurrentTests;
    private boolean myIsTerminated;
    private JUnitRunningModel myModel;
    private final JUnitConsoleProperties myConsoleProperties;

    public static void mapClass(int magnitude, @NotNull StateChanger factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/junit2/ui/TestsPacketsReceiver", "mapClass"));
        }
        factory.setMagnitude(magnitude);
        STATE_CLASSES.put(magnitude, (Object)factory);
    }

    public TestsPacketsReceiver(@NotNull JUnitTreeConsoleView consoleView, @NotNull TestProxy unboundOutput) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/junit2/ui/TestsPacketsReceiver", "<init>"));
        }
        if (unboundOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unboundOutput", "com/intellij/execution/junit2/ui/TestsPacketsReceiver", "<init>"));
        }
        this.myCurrentTests = new HashSet<TestProxy>();
        this.myIsTerminated = false;
        this.myUnboundOutput = unboundOutput;
        this.myObjectRegistry = new InputObjectRegistry();
        this.myConsoleProperties = (JUnitConsoleProperties)consoleView.getProperties();
    }

    public void processPacket(String packet) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (packet.startsWith("T")) {
            this.notifyStart(TestsPacketsReceiver.readNode(new ObjectReader(packet, "T".length(), this.myObjectRegistry)));
        } else if (packet.startsWith("I")) {
            this.notifyTestStart(new ObjectReader(packet, "I".length(), this.myObjectRegistry));
        } else if (packet.startsWith("S")) {
            this.notifyTestResult(new ObjectReader(packet, "S".length(), this.myObjectRegistry));
        } else if (packet.startsWith("D")) {
            this.notifyFinish(new ObjectReader(packet, "D".length(), this.myObjectRegistry));
        } else if (packet.startsWith("O")) {
            this.myObjectRegistry.readPacketFrom(new ObjectReader(packet, "O".length(), this.myObjectRegistry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOutput(Printable printable) {
        Set<TestProxy> set = this.myCurrentTests;
        synchronized (set) {
            if (this.myCurrentTests.isEmpty()) {
                this.myUnboundOutput.addLast(printable);
            } else {
                for (TestProxy currentTest : this.myCurrentTests) {
                    currentTest.addLast(printable);
                }
            }
        }
    }

    public synchronized void notifyStart(TestProxy root) {
        this.myModel = new JUnitRunningModel(root, this.myConsoleProperties);
        Disposer.register((Disposable)this, (Disposable)this.myModel);
    }

    private static TestProxy readNode(ObjectReader reader) {
        TestProxy node = reader.readObject();
        int childCount = reader.readInt();
        for (int i = 0; i < childCount; ++i) {
            node.addChild(TestsPacketsReceiver.readNode(reader));
        }
        return node;
    }

    public void notifyTestStart(ObjectReader reader) {
        TestProxy testProxy = reader.readObject();
        JUnitRunningModel model = this.getModel();
        if (model != null && testProxy.getParent() == null && model.getRoot() != testProxy) {
            this.getDynamicParent(model, testProxy).addChild(testProxy);
        }
    }

    private TestProxy getDynamicParent(JUnitRunningModel model, TestProxy currentTest) {
        String parentClass;
        TestProxy dynamicParent;
        if (this.myKnownDynamicParents == null) {
            this.myKnownDynamicParents = new HashMap();
        }
        if ((dynamicParent = this.myKnownDynamicParents.get(parentClass = currentTest.getInfo().getComment())) == null) {
            TestProxy root = TestsPacketsReceiver.findParent(parentClass, model.getRoot());
            if (root != null) {
                dynamicParent = root;
            } else {
                dynamicParent = new TestProxy(new ClassBasedInfo(DisplayTestInfoExtractor.FOR_CLASS){
                    {
                        super(x0);
                        this.setClassName(parentClass);
                    }

                    @Override
                    public void readFrom(ObjectReader reader) {
                    }
                });
                model.getRoot().addChild(dynamicParent);
            }
            this.myKnownDynamicParents.put(parentClass, dynamicParent);
        }
        return dynamicParent;
    }

    private static TestProxy findParent(String parentClass, TestProxy root) {
        if (TestsPacketsReceiver.isAccepted(root, parentClass)) {
            return root;
        }
        for (TestProxy proxy : root.getChildren()) {
            if (!TestsPacketsReceiver.isAccepted(proxy, parentClass)) continue;
            return proxy;
        }
        return null;
    }

    private static boolean isAccepted(TestProxy root, String parentClass) {
        return Comparing.strEqual((String)parentClass, (String)StringUtil.getQualifiedName((String)root.getInfo().getComment(), (String)root.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTestResult(ObjectReader reader) {
        TestProxy testProxy = reader.readObject();
        if (testProxy.getParent() == null) {
            this.getDynamicParent(this.myModel, testProxy).insertNextRunningChild(testProxy);
        }
        int state = reader.readInt();
        StateChanger stateChanger = (StateChanger)STATE_CLASSES.get(state);
        stateChanger.changeStateOf(testProxy, reader);
        Set<TestProxy> set = this.myCurrentTests;
        synchronized (set) {
            if (stateChanger instanceof RunningStateSetter) {
                this.myCurrentTests.add(testProxy);
            } else {
                this.myCurrentTests.remove((Object)testProxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFinish(ObjectReader reader) {
        this.myIsTerminated = true;
        Set<TestProxy> set = this.myCurrentTests;
        synchronized (set) {
            this.myCurrentTests.clear();
        }
        JUnitRunningModel model = this.getModel();
        if (model != null) {
            model.getNotifier().fireRunnerStateChanged(new CompletionEvent(true, reader.readInt()));
            TestStatusListener.notifySuiteFinished((AbstractTestProxy)model.getRoot(), (Project)model.getProject());
            this.terminateStillRunning(model);
        }
    }

    public synchronized boolean isRunning() {
        return !this.myIsTerminated;
    }

    public synchronized void setTerminated(boolean terminated) {
        this.myIsTerminated = terminated;
    }

    @Nullable
    public JUnitRunningModel getModel() {
        return this.myModel;
    }

    public void dispose() {
        this.myModel = null;
    }

    public void checkTerminated() {
        if (this.isRunning()) {
            JUnitListenersNotifier notifier;
            JUnitRunningModel model = this.getModel();
            if (model != null && (notifier = model.getNotifier()) != null) {
                notifier.fireRunnerStateChanged(new CompletionEvent(false, -1L));
                this.terminateStillRunning(model);
            }
            this.setTerminated(true);
        }
    }

    private void terminateStillRunning(@NotNull JUnitRunningModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/execution/junit2/ui/TestsPacketsReceiver", "terminateStillRunning"));
        }
        if (model.getRoot() != null) {
            List runningTests = TestStateUpdater.RUNNING_LEAF.select(this.myModel.getRoot().getAllTests());
            for (AbstractTestProxy runningTest : runningTests) {
                TestProxy testProxy = (TestProxy)runningTest;
                TestState terminated = NotFailedState.createTerminated();
                testProxy.setState(terminated);
                for (TestProxy parent = testProxy.getParent(); parent != null; parent = parent.getParent()) {
                    parent.setState(terminated);
                }
            }
        }
    }

    static {
        TestsPacketsReceiver.mapClass(3, new RunningStateSetter());
        TestsPacketsReceiver.mapClass(1, new TestCompleter());
        TestsPacketsReceiver.mapClass(6, new StateReader(FaultyState.class));
        TestsPacketsReceiver.mapClass(8, new StateReader(FaultyState.class));
        TestsPacketsReceiver.mapClass(5, new StateReader(IgnoredState.class));
        TestsPacketsReceiver.mapClass(0, new StateReader(SkippedState.class));
        TestsPacketsReceiver.mapClass(7, new StateReader(ComparisonFailureState.class));
    }

    private static class TestCompleter
    extends StateChanger {
        private TestCompleter() {
        }

        @Override
        public void changeStateOf(TestProxy testProxy, ObjectReader reader) {
            TestState state = testProxy.getState();
            if (!testProxy.getState().isFinal()) {
                state = NotFailedState.createPassed();
            }
            testProxy.setState(state);
            testProxy.setStatistics(new Statistics(reader));
            TestCompleter.complete(testProxy);
        }
    }

    private static class StateReader
    extends StateChanger {
        private final Class<? extends ReadableState> myStateClass;
        private int myInstanceMagnitude;

        public StateReader(Class<? extends ReadableState> stateClass) {
            this.myStateClass = stateClass;
        }

        @Override
        public void changeStateOf(TestProxy testProxy, ObjectReader reader) {
            ReadableState state;
            try {
                state = this.myStateClass.newInstance();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return;
            }
            state.setMagitude(this.myInstanceMagnitude);
            state.initializeFrom(reader);
            testProxy.setState(state);
            StateReader.complete(testProxy);
        }

        @Override
        public void setMagnitude(int magnitude) {
            this.myInstanceMagnitude = magnitude;
        }
    }

    private static class RunningStateSetter
    extends StateChanger {
        private RunningStateSetter() {
        }

        @Override
        public void changeStateOf(TestProxy testProxy, ObjectReader reader) {
            testProxy.setState(TestState.RUNNING_STATE);
            for (TestProxy parent = testProxy.getParent(); parent != null; parent = parent.getParent()) {
                TestState state = parent.getState();
                if (!(state instanceof SuiteState)) continue;
                ((SuiteState)state).setRunning(true);
            }
        }
    }

    private static abstract class StateChanger {
        static final Logger LOG = Logger.getInstance((String)("#" + StateChanger.class.getName()));

        private StateChanger() {
        }

        abstract void changeStateOf(TestProxy var1, ObjectReader var2);

        void setMagnitude(int magnitude) {
        }

        static void complete(TestProxy testProxy) {
            int magnitude = testProxy.getState().getMagnitude();
            TestProxy child = testProxy;
            for (TestProxy parent = testProxy.getParent(); parent != null; parent = parent.getParent()) {
                List<TestProxy> children = parent.getChildren();
                TestState parentState = parent.getState();
                if (parentState instanceof SuiteState) {
                    if (!child.isInProgress() && ((Object)((Object)child)).equals((Object)children.get(children.size() - 1))) {
                        ((SuiteState)parentState).setRunning(false);
                        parent.fireStateChanged();
                        parent.flush();
                    }
                    ((SuiteState)parentState).updateMagnitude(magnitude);
                }
                child = parent;
            }
        }
    }
}

