/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.List;

public class TestClassConfigurationProducer
extends JUnitConfigurationProducer {
    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        String paramSetName;
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation && (paramSetName = ((PsiMemberParameterizedLocation)contextLocation).getParamSetName()) != null) {
            configuration.setProgramParameters(paramSetName);
        }
        if (PatternConfigurationProducer.isMultipleElementsSelected(context)) {
            return false;
        }
        PsiClass testClass = JUnitUtil.getTestClass((Location)location);
        if (testClass == null) {
            return false;
        }
        sourceElement.set((Object)testClass);
        this.setupConfigurationModule(context, configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.beClassConfiguration(testClass);
        configuration.restoreOriginalModule(originalModule);
        String forkMode = configuration.getForkMode();
        if ("class".equals(forkMode)) {
            configuration.setForkMode("none");
        }
        return true;
    }

    public void onFirstRun(final ConfigurationFromContext fromContext, ConfigurationContext context, Runnable performRunnable) {
        InheritorChooser inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                ((JUnitConfiguration)fromContext.getConfiguration()).bePatternConfiguration(classes, method);
                super.runForClasses(classes, method, context, performRunnable);
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                ((JUnitConfiguration)fromContext.getConfiguration()).beClassConfiguration(aClass);
                super.runForClass(aClass, psiMethod, context, performRunnable);
            }
        };
        if (inheritorChooser.runMethodInAbstractClass(context, performRunnable, null, (PsiClass)fromContext.getSourceElement())) {
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }
}

