/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.WinSize;
import com.pty4j.unix.PTYInputStream;
import com.pty4j.unix.PTYOutputStream;
import com.pty4j.unix.PtyHelpers;
import com.pty4j.util.Pair;
import java.io.IOException;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Termios;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pty {
    private final boolean myConsole;
    private String mySlaveName;
    private PTYInputStream myIn;
    private PTYOutputStream myOut;
    private final Object myFDLock = new Object();
    private final Object mySelectLock = new Object();
    private final int[] myPipe = new int[2];
    private volatile int myMaster;
    private static boolean setTerminalSizeErrorAlreadyLogged;
    private static final Object PTSNAME_LOCK;

    public Pty() throws IOException {
        this(false);
    }

    public Pty(boolean console) throws IOException {
        this.myConsole = console;
        Pair<Integer, String> masterSlave = this.openMaster(console);
        this.myMaster = (Integer)masterSlave.first;
        this.mySlaveName = (String)masterSlave.second;
        if (this.mySlaveName == null) {
            throw new IOException("Util.exception.cannotCreatePty");
        }
        this.myIn = new PTYInputStream(this);
        this.myOut = new PTYOutputStream(this);
        JTermios.pipe((int[])this.myPipe);
    }

    public String getSlaveName() {
        return this.mySlaveName;
    }

    public int getMasterFD() {
        return this.myMaster;
    }

    public final boolean isConsole() {
        return this.myConsole;
    }

    public PTYOutputStream getOutputStream() {
        return this.myOut;
    }

    public PTYInputStream getInputStream() {
        return this.myIn;
    }

    public final void setTerminalSize(int width, int height) {
        block2: {
            try {
                Pty.changeWindowsSize(this.myMaster, width, height);
            }
            catch (UnsatisfiedLinkError e) {
                if (setTerminalSizeErrorAlreadyLogged) break block2;
                setTerminalSizeErrorAlreadyLogged = true;
            }
        }
    }

    public WinSize getWinSize() throws IOException {
        WinSize result = new WinSize();
        if (PtyHelpers.getWinSize(this.myMaster, result) < 0) {
            throw new IOException("Failed to get window size: " + PtyHelpers.errno());
        }
        return result;
    }

    private Pair<Integer, String> ptyMasterOpen() {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        String name = "/dev/ptmx";
        int fdm = m_jpty.getpt();
        if (fdm < 0) {
            return Pair.create(-1, name);
        }
        if (m_jpty.grantpt(fdm) < 0) {
            m_jpty.close(fdm);
            return Pair.create(-2, name);
        }
        if (m_jpty.unlockpt(fdm) < 0) {
            m_jpty.close(fdm);
            return Pair.create(-3, name);
        }
        String ptr = Pty.ptsname(m_jpty, fdm);
        if (ptr == null) {
            m_jpty.close(fdm);
            return Pair.create(-4, name);
        }
        return Pair.create(fdm, ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ptsname(PtyHelpers.OSFacade m_jpty, int fdm) {
        Object object = PTSNAME_LOCK;
        synchronized (object) {
            return m_jpty.ptsname(fdm);
        }
    }

    public static void setNoEcho(int fd) {
        Termios stermios = new Termios();
        if (JTermios.tcgetattr((int)fd, (Termios)stermios) < 0) {
            return;
        }
        stermios.c_lflag &= ~(JTermios.ECHO | JTermios.ECHOE | PtyHelpers.ECHOK | JTermios.ECHONL);
        stermios.c_iflag |= JTermios.IGNCR;
        JTermios.tcsetattr((int)fd, (int)JTermios.TCSANOW, (Termios)stermios);
    }

    private Pair<Integer, String> openMaster(boolean console) {
        Pair<Integer, String> master = this.ptyMasterOpen();
        if ((Integer)master.first >= 0 && console) {
            Pty.setNoEcho((Integer)master.first);
        }
        return master;
    }

    public static int changeWindowsSize(int fd, int width, int height) {
        return PtyHelpers.getInstance().setWinSize(fd, new WinSize(width, height));
    }

    public static int raise(int pid, int sig) {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        int status = m_jpty.killpg(pid, sig);
        if (status == -1) {
            status = m_jpty.kill(pid, sig);
        }
        return status;
    }

    public boolean isClosed() {
        return this.myMaster == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.myMaster != -1) {
            Object object = this.myFDLock;
            synchronized (object) {
                if (this.myMaster != -1) {
                    try {
                        int status = this.close0(this.myMaster);
                        if (status == -1) {
                            throw new IOException("Close error");
                        }
                    }
                    finally {
                        this.myMaster = -1;
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int close0(int fd) throws IOException {
        int ret = JTermios.close((int)fd);
        JTermios.write((int)this.myPipe[1], (byte[])new byte[1], (int)1);
        Object object = this.mySelectLock;
        synchronized (object) {
            JTermios.close((int)this.myPipe[0]);
            JTermios.close((int)this.myPipe[1]);
            this.myPipe[0] = -1;
            this.myPipe[1] = -1;
        }
        return ret;
    }

    public static int wait0(int pid) {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        int[] status = new int[1];
        if (pid < 0) {
            return -1;
        }
        while (m_jpty.waitpid(pid, status, 0) < 0 && JTermios.errno() == JTermios.EINTR) {
        }
        if (Pty.WIFEXITED(status[0])) {
            return Pty.WEXITSTATUS(status[0]);
        }
        return status[0];
    }

    static int WEXITSTATUS(int status) {
        return status >> 8 & 0xFF;
    }

    static boolean WIFEXITED(int status) {
        return Pty._WSTATUS(status) == 0;
    }

    private static int _WSTATUS(int status) {
        return status & 0x7F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] buf, int len) throws IOException {
        int fd = this.myMaster;
        if (fd == -1) {
            return -1;
        }
        FDSet set = JTermios.newFDSet();
        Object object = this.mySelectLock;
        synchronized (object) {
            if (this.myPipe[0] == -1) {
                return -1;
            }
            JTermios.FD_SET((int)this.myPipe[0], (FDSet)set);
            JTermios.FD_SET((int)fd, (FDSet)set);
            JTermios.select((int)(Math.max(fd, this.myPipe[0]) + 1), (FDSet)set, null, null, null);
        }
        return JTermios.FD_ISSET((int)fd, (FDSet)set) ? JTermios.read((int)fd, (byte[])buf, (int)len) : -1;
    }

    int write(byte[] buf, int len) throws IOException {
        return JTermios.write((int)this.myMaster, (byte[])buf, (int)len);
    }

    static {
        PTSNAME_LOCK = new Object();
    }
}

