/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.maven.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenArtifactSearcher;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.plugins.gradle.codeInsight.AbstractGradleCompletionContributor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;

public class MavenDependenciesGradleCompletionContributor
extends AbstractGradleCompletionContributor {
    private static final String GROUP_LABEL = "group";
    private static final String NAME_LABEL = "name";
    private static final String VERSION_LABEL = "version";
    private static final String DEPENDENCIES_SCRIPT_BLOCK = "dependencies";
    private static final ElementPattern<PsiElement> DEPENDENCIES_CALL_PATTERN = PlatformPatterns.psiElement().inside(true, (ElementPattern)PlatformPatterns.psiElement(GrMethodCallExpression.class).with((PatternCondition)new PatternCondition<GrMethodCallExpression>("withInvokedExpressionText"){

        public boolean accepts(@NotNull GrMethodCallExpression expression, ProcessingContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/gradle/integrations/maven/codeInsight/completion/MavenDependenciesGradleCompletionContributor$1", "accepts"));
            }
            if (this.checkExpression(expression)) {
                return true;
            }
            return this.checkExpression((GrMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, GrMethodCallExpression.class));
        }

        private boolean checkExpression(@Nullable GrMethodCallExpression expression) {
            if (expression == null) {
                return false;
            }
            GrExpression grExpression = expression.getInvokedExpression();
            return grExpression != null && MavenDependenciesGradleCompletionContributor.DEPENDENCIES_SCRIPT_BLOCK.equals(grExpression.getText());
        }
    }));
    private static final ElementPattern<PsiElement> IN_MAP_DEPENDENCY_NOTATION = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(GRADLE_FILE_PATTERN)).withParent(GrLiteral.class)).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(GrNamedArgument.class))).and(DEPENDENCIES_CALL_PATTERN);
    private static final ElementPattern<PsiElement> IN_METHOD_DEPENDENCY_NOTATION = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(GRADLE_FILE_PATTERN)).and(DEPENDENCIES_CALL_PATTERN);

    public MavenDependenciesGradleCompletionContributor() {
        this.extend(CompletionType.BASIC, IN_MAP_DEPENDENCY_NOTATION, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters params, ProcessingContext context, @NotNull CompletionResultSet result) {
                block10: {
                    GrNamedArgument namedArgument;
                    block11: {
                        block9: {
                            if (params == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/gradle/integrations/maven/codeInsight/completion/MavenDependenciesGradleCompletionContributor$2", "addCompletions"));
                            }
                            if (result == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/gradle/integrations/maven/codeInsight/completion/MavenDependenciesGradleCompletionContributor$2", "addCompletions"));
                            }
                            result.stopHere();
                            PsiElement parent = params.getPosition().getParent().getParent();
                            if (!(parent instanceof GrNamedArgument) || !(parent.getParent() instanceof GrNamedArgumentsOwner)) {
                                return;
                            }
                            namedArgument = (GrNamedArgument)parent;
                            if (!MavenDependenciesGradleCompletionContributor.GROUP_LABEL.equals(namedArgument.getLabelName())) break block9;
                            MavenProjectIndicesManager m = MavenProjectIndicesManager.getInstance((Project)namedArgument.getProject());
                            for (String groupId : m.getGroupIds()) {
                                LookupElementBuilder builder = LookupElementBuilder.create((String)groupId).withIcon(AllIcons.Nodes.PpLib);
                                result.addElement((LookupElement)builder);
                            }
                            break block10;
                        }
                        if (!MavenDependenciesGradleCompletionContributor.NAME_LABEL.equals(namedArgument.getLabelName())) break block11;
                        String groupId = MavenDependenciesGradleCompletionContributor.this.findNamedArgumentValue((GrNamedArgumentsOwner)namedArgument.getParent(), MavenDependenciesGradleCompletionContributor.GROUP_LABEL);
                        if (groupId == null) {
                            return;
                        }
                        MavenProjectIndicesManager m = MavenProjectIndicesManager.getInstance((Project)namedArgument.getProject());
                        for (String artifactId : m.getArtifactIds(groupId)) {
                            LookupElementBuilder builder = LookupElementBuilder.create((String)artifactId).withIcon(AllIcons.Nodes.PpLib);
                            result.addElement((LookupElement)builder);
                        }
                        break block10;
                    }
                    if (!MavenDependenciesGradleCompletionContributor.VERSION_LABEL.equals(namedArgument.getLabelName())) break block10;
                    GrNamedArgumentsOwner namedArgumentsOwner = (GrNamedArgumentsOwner)namedArgument.getParent();
                    String groupId = MavenDependenciesGradleCompletionContributor.this.findNamedArgumentValue(namedArgumentsOwner, MavenDependenciesGradleCompletionContributor.GROUP_LABEL);
                    if (groupId == null) {
                        return;
                    }
                    String artifactId = MavenDependenciesGradleCompletionContributor.this.findNamedArgumentValue(namedArgumentsOwner, MavenDependenciesGradleCompletionContributor.NAME_LABEL);
                    if (artifactId == null) {
                        return;
                    }
                    MavenProjectIndicesManager m = MavenProjectIndicesManager.getInstance((Project)namedArgument.getProject());
                    for (String version : m.getVersions(groupId, artifactId)) {
                        LookupElementBuilder builder = LookupElementBuilder.create((String)version).withIcon(AllIcons.Nodes.PpLib);
                        result.addElement((LookupElement)builder);
                    }
                }
            }
        });
        this.extend(CompletionType.BASIC, IN_METHOD_DEPENDENCY_NOTATION, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters params, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (params == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/gradle/integrations/maven/codeInsight/completion/MavenDependenciesGradleCompletionContributor$3", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/gradle/integrations/maven/codeInsight/completion/MavenDependenciesGradleCompletionContributor$3", "addCompletions"));
                }
                result.stopHere();
                PsiElement parent = params.getPosition().getParent();
                if (!(parent instanceof GrLiteral) || !(parent.getParent() instanceof GrArgumentList)) {
                    return;
                }
                String searchText = CompletionUtil.findReferenceOrAlphanumericPrefix((CompletionParameters)params);
                MavenArtifactSearcher searcher = new MavenArtifactSearcher();
                List searchResults = searcher.search(params.getPosition().getProject(), searchText, 100);
                for (MavenArtifactSearchResult searchResult : searchResults) {
                    for (MavenArtifactInfo artifactInfo : searchResult.versions) {
                        StringBuilder buf = new StringBuilder();
                        MavenId.append((StringBuilder)buf, (String)artifactInfo.getGroupId());
                        MavenId.append((StringBuilder)buf, (String)artifactInfo.getArtifactId());
                        MavenId.append((StringBuilder)buf, (String)artifactInfo.getVersion());
                        LookupElementBuilder builder = LookupElementBuilder.create((String)buf.toString()).withIcon(AllIcons.Nodes.PpLib);
                        result.addElement((LookupElement)builder);
                    }
                }
            }
        });
    }
}

