/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FxmlDataExternalizer
implements DataExternalizer<Set<String>> {
    public void save(@NotNull DataOutput out, Set<String> value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/plugins/javaFX/FxmlDataExternalizer", "save"));
        }
        out.writeInt(value.size());
        for (String s : value) {
            out.writeUTF(s);
        }
    }

    public Set<String> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/plugins/javaFX/FxmlDataExternalizer", "read"));
        }
        int size = in.readInt();
        HashSet<String> result = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            String s = in.readUTF();
            result.add(s);
        }
        return result;
    }
}

