/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NewFileTracker {
    private final Set<VirtualFile> newFiles = Collections.synchronizedSet(new THashSet());
    private static final NewFileTracker instance = new NewFileTracker();

    public static NewFileTracker getInstance() {
        return instance;
    }

    public boolean poll(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/maddyhome/idea/copyright/util/NewFileTracker", "poll"));
        }
        return this.newFiles.remove(file);
    }

    private NewFileTracker() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        virtualFileManager.addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/maddyhome/idea/copyright/util/NewFileTracker$1", "fileCreated"));
                }
                if (event.isFromRefresh()) {
                    return;
                }
                NewFileTracker.this.newFiles.add(event.getFile());
            }
        });
    }

    public void clear() {
        this.newFiles.clear();
    }
}

