/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nullable;

public class EclipseUserLibrariesHelper {
    private EclipseUserLibrariesHelper() {
    }

    private static void writeUserLibrary(Library library, Element libElement) {
        VirtualFile[] files;
        for (VirtualFile file : files = library.getFiles(OrderRootType.CLASSES)) {
            VirtualFile localFile;
            Element archElement = new Element("archive");
            if (file.getFileSystem() instanceof JarFileSystem && (localFile = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
                file = localFile;
            }
            archElement.setAttribute("path", file.getPath());
            libElement.addContent(archElement);
        }
    }

    public static void appendProjectLibraries(Project project, @Nullable File userLibrariesFile) throws IOException {
        if (userLibrariesFile == null) {
            return;
        }
        if (userLibrariesFile.exists() && !userLibrariesFile.isFile()) {
            return;
        }
        File parentFile = userLibrariesFile.getParentFile();
        if (parentFile == null) {
            return;
        }
        if (!parentFile.isDirectory() && !parentFile.mkdir()) {
            return;
        }
        Element userLibsElement = new Element("eclipse-userlibraries");
        ArrayList<Library> libraries = new ArrayList<Library>(Arrays.asList(ProjectLibraryTable.getInstance((Project)project).getLibraries()));
        ContainerUtil.addAll(libraries, (Object[])LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries());
        for (Library library : libraries) {
            Element libElement = new Element("library");
            libElement.setAttribute("name", library.getName());
            EclipseUserLibrariesHelper.writeUserLibrary(library, libElement);
            userLibsElement.addContent(libElement);
        }
        JDOMUtil.writeDocument((Document)new Document(userLibsElement), (File)userLibrariesFile, (String)"\n");
    }

    public static void readProjectLibrariesContent(File exportedFile, Project project, Collection<String> unknownLibraries) throws IOException, JDOMException {
        if (exportedFile.exists()) {
            LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)project);
            Element rootElement = JDOMUtil.loadDocument((File)exportedFile).getRootElement();
            for (Element o : rootElement.getChildren("library")) {
                LibraryTable.ModifiableModel model;
                Element libElement = o;
                String libName = libElement.getAttributeValue("name");
                Library libraryByName = libraryTable.getLibraryByName(libName);
                if (libraryByName == null) {
                    model = libraryTable.getModifiableModel();
                    libraryByName = model.createLibrary(libName);
                    model.commit();
                }
                if (libraryByName != null) {
                    model = libraryByName.getModifiableModel();
                    for (Element a : libElement.getChildren("archive")) {
                        VirtualFile jarFile;
                        String rootPath = a.getAttributeValue("path");
                        if (rootPath.startsWith("/")) {
                            rootPath = project.getBaseDir().getPath() + rootPath;
                        }
                        String url = VfsUtil.pathToUrl((String)rootPath);
                        VirtualFile localFile = VirtualFileManager.getInstance().findFileByUrl(url);
                        if (localFile != null && (jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile)) != null) {
                            url = jarFile.getUrl();
                        }
                        model.addRoot(url, OrderRootType.CLASSES);
                    }
                    model.commit();
                }
                unknownLibraries.remove(libName);
            }
        }
    }
}

