/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom.Element;
import org.jdom.output.EclipseXMLOutputter;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;

public class EclipseJDOMUtil {
    private EclipseJDOMUtil() {
    }

    private static EclipseXMLOutputter createOutputter(String lineSeparator) {
        EclipseXMLOutputter xmlOutputter = new EclipseXMLOutputter(lineSeparator);
        Format format = Format.getCompactFormat().setIndent("\t").setTextMode(Format.TextMode.NORMALIZE).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false);
        xmlOutputter.setFormat(format);
        return xmlOutputter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void output(@NotNull Element element, @NotNull File file, @NotNull Project project) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jdom/output/EclipseJDOMUtil", "output"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jdom/output/EclipseJDOMUtil", "output"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jdom/output/EclipseJDOMUtil", "output"));
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            EclipseJDOMUtil.output(element, writer, project);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public static void output(@NotNull Element element, @NotNull Writer writer, @NotNull Project project) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jdom/output/EclipseJDOMUtil", "output"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jdom/output/EclipseJDOMUtil", "output"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jdom/output/EclipseJDOMUtil", "output"));
        }
        String lineSeparator = CodeStyleSettingsManager.getSettings((Project)project).getLineSeparator();
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write(lineSeparator);
        EclipseJDOMUtil.createOutputter(lineSeparator).output(element, writer);
    }
}

