/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.jediterm.terminal.TtyConnectorWaitFor;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalActionProviderBase;
import com.jediterm.terminal.ui.settings.TabbedSettingsProvider;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalSessionEditor
extends UserDataHolderBase
implements FileEditor {
    private Project myProject;
    private final TerminalSessionVirtualFileImpl myFile;
    private final TtyConnectorWaitFor myWaitFor;

    public TerminalSessionEditor(Project project, @NotNull TerminalSessionVirtualFileImpl terminalFile) {
        if (terminalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalFile", "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor", "<init>"));
        }
        this.myProject = project;
        this.myFile = terminalFile;
        final TabbedSettingsProvider settings = this.myFile.getSettingsProvider();
        this.myFile.getTerminal().setNextProvider((TerminalActionProvider)new TerminalActionProviderBase(){

            public List<TerminalAction> getActions() {
                return Lists.newArrayList((Object[])new TerminalAction[]{new TerminalAction("Close Session", settings.getCloseSessionKeyStrokes(), (Predicate)new Predicate<KeyEvent>(){

                    public boolean apply(KeyEvent input) {
                        TerminalSessionEditor.this.handleCloseSession();
                        return true;
                    }
                }).withMnemonicKey(Integer.valueOf(83))});
            }
        });
        this.myWaitFor = new TtyConnectorWaitFor(this.myFile.getTerminal().getTtyConnector(), Executors.newSingleThreadExecutor());
        this.myWaitFor.setTerminationCallback((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer integer) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManagerEx.getInstanceEx((Project)TerminalSessionEditor.this.myProject).closeFile((VirtualFile)TerminalSessionEditor.this.myFile);
                    }
                });
                return true;
            }
        });
    }

    private void handleCloseSession() {
        this.myFile.getTerminal().close();
    }

    @NotNull
    public JComponent getComponent() {
        JediTermWidget jediTermWidget = this.myFile.getTerminal();
        if (jediTermWidget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor", "getComponent"));
        }
        return jediTermWidget;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myFile.getTerminal();
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor", "getName"));
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        Boolean closingToReopen = (Boolean)this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN);
        this.myWaitFor.detach();
        if (closingToReopen == null || !closingToReopen.booleanValue()) {
            this.myFile.getTerminal().close();
        }
    }
}

