/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="TerminalOptionsProvider", storages={@Storage(file="$APP_CONFIG$/terminal.xml")})
public class TerminalOptionsProvider
implements PersistentStateComponent<State>,
ExportableApplicationComponent {
    private State myState = new State();

    public static TerminalOptionsProvider getInstance() {
        return (TerminalOptionsProvider)ApplicationManager.getApplication().getComponent(TerminalOptionsProvider.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState.myShellPath = state.myShellPath;
        this.myState.myCloseSessionOnLogout = state.myCloseSessionOnLogout;
        this.myState.myReportMouse = state.myReportMouse;
        this.myState.mySoundBell = state.mySoundBell;
        this.myState.myTabName = state.myTabName;
        this.myState.myCopyOnSelection = state.myCopyOnSelection;
        this.myState.myPasteOnMiddleMouseButton = state.myPasteOnMiddleMouseButton;
        this.myState.myOverrideIdeShortcuts = state.myOverrideIdeShortcuts;
    }

    public boolean closeSessionOnLogout() {
        return this.myState.myCloseSessionOnLogout;
    }

    public boolean enableMouseReporting() {
        return this.myState.myReportMouse;
    }

    public boolean audibleBell() {
        return this.myState.mySoundBell;
    }

    public String getTabName() {
        return this.myState.myTabName;
    }

    public boolean overrideIdeShortcuts() {
        return this.myState.myOverrideIdeShortcuts;
    }

    public void setOverrideIdeShortcuts(boolean overrideIdeShortcuts) {
        this.myState.myOverrideIdeShortcuts = overrideIdeShortcuts;
    }

    public String getShellPath() {
        return this.myState.myShellPath;
    }

    private static String getDefaultShellPath() {
        String shell = System.getenv("SHELL");
        if (shell != null && new File(shell).canExecute()) {
            return shell;
        }
        if (SystemInfo.isUnix) {
            return "/bin/bash";
        }
        return "cmd.exe";
    }

    public void setShellPath(String shellPath) {
        this.myState.myShellPath = shellPath;
    }

    public void setTabName(String tabName) {
        this.myState.myTabName = tabName;
    }

    public void setCloseSessionOnLogout(boolean closeSessionOnLogout) {
        this.myState.myCloseSessionOnLogout = closeSessionOnLogout;
    }

    public void setReportMouse(boolean reportMouse) {
        this.myState.myReportMouse = reportMouse;
    }

    public void setSoundBell(boolean soundBell) {
        this.myState.mySoundBell = soundBell;
    }

    public boolean copyOnSelection() {
        return this.myState.myCopyOnSelection;
    }

    public void setCopyOnSelection(boolean copyOnSelection) {
        this.myState.myCopyOnSelection = copyOnSelection;
    }

    public boolean pasteOnMiddleMouseButton() {
        return this.myState.myPasteOnMiddleMouseButton;
    }

    public void setPasteOnMiddleMouseButton(boolean pasteOnMiddleMouseButton) {
        this.myState.myPasteOnMiddleMouseButton = pasteOnMiddleMouseButton;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{new File(PathManager.getOptionsPath() + File.separatorChar + "terminal.xml")};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/TerminalOptionsProvider", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        if ("TerminalOptions" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/TerminalOptionsProvider", "getPresentableName"));
        }
        return "TerminalOptions";
    }

    @NotNull
    public String getComponentName() {
        if ("TerminalOptionsProvider" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/TerminalOptionsProvider", "getComponentName"));
        }
        return "TerminalOptionsProvider";
    }

    static /* synthetic */ String access$000() {
        return TerminalOptionsProvider.getDefaultShellPath();
    }

    public static class State {
        public String myShellPath = TerminalOptionsProvider.access$000();
        public String myTabName = "Local";
        public boolean myCloseSessionOnLogout = true;
        public boolean myReportMouse = true;
        public boolean mySoundBell = true;
        public boolean myCopyOnSelection = true;
        public boolean myPasteOnMiddleMouseButton = true;
        public boolean myOverrideIdeShortcuts = true;
    }
}

