/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.output.GradleMessage;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ManifestMergeFailureParser
implements PatternAwareOutputParser {
    private static final Pattern ERROR1 = Pattern.compile("\\[([^:].[^:]+):(\\d+)\\] (.+)");
    private static final Pattern ERROR2 = Pattern.compile("([^:].[^:]+):(\\d+):(\\d+) (.+):");

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<GradleMessage> messages, @NotNull ILogger logger) throws ParsingFailedException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser", "parse"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser", "parse"));
        }
        Matcher m = ERROR1.matcher(line);
        if (m.matches()) {
            int lineNumber;
            String sourcePath = m.group(1);
            try {
                lineNumber = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            String message = m.group(3);
            messages.add(new GradleMessage(GradleMessage.Kind.ERROR, message, sourcePath, lineNumber, -1));
            return true;
        }
        m = ERROR2.matcher(line);
        if (m.matches()) {
            int column;
            int lineNumber;
            String sourcePath = ManifestMergeFailureParser.removeLeadingTab(m.group(1)).trim();
            try {
                lineNumber = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            try {
                column = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            if (lineNumber == 0 && column == 0) {
                String next = reader.peek(0);
                if (next != null && next.contains("Validation failed, exiting")) {
                    reader.readLine();
                    return true;
                }
            } else {
                String msg = reader.readLine();
                if (msg != null) {
                    msg = ManifestMergeFailureParser.removeLeadingTab(msg).trim();
                    GradleMessage.Kind kind = GradleMessage.Kind.findIgnoringCase((String)m.group(4));
                    if (kind == null) {
                        kind = GradleMessage.Kind.ERROR;
                    }
                    messages.add(new GradleMessage(kind, msg.trim(), sourcePath, lineNumber, column));
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static String removeLeadingTab(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser", "removeLeadingTab"));
        }
        if (s.startsWith("\t") && s.length() > 1) {
            String string = s.substring(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser", "removeLeadingTab"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser", "removeLeadingTab"));
        }
        return string;
    }
}

