/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.PositionImpl;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderHandler {
    public static final String INSTRUMENTATION_RUNNER = "instrumentationRunner";
    public static final String PACKAGE_NAME = "packageName";
    public static final String APPLICATION_ID = "applicationId";
    static final Pattern PATTERN = Pattern.compile("([^\\$]*)\\$\\{([^\\}]*)\\}(.*)");

    public static boolean isPlaceHolder(@NonNull String string) {
        return PATTERN.matcher(string).matches();
    }

    public void visit(@NonNull ManifestMerger2.MergeType mergeType, @NonNull XmlDocument xmlDocument, @NonNull KeyBasedValueResolver<String> valueProvider, @NonNull MergingReport.Builder mergingReportBuilder) {
        this.visit(mergeType, xmlDocument.getRootNode(), valueProvider, mergingReportBuilder);
    }

    private void visit(@NonNull ManifestMerger2.MergeType mergeType, @NonNull XmlElement xmlElement, @NonNull KeyBasedValueResolver<String> valueProvider, @NonNull MergingReport.Builder mergingReportBuilder) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            StringBuilder resultString = new StringBuilder();
            String inputString = xmlAttribute.getValue();
            Matcher matcher = PATTERN.matcher(inputString);
            if (!matcher.matches()) continue;
            while (matcher.matches()) {
                String placeholderValue = valueProvider.getValue(matcher.group(2));
                resultString.append(matcher.group(1));
                if (placeholderValue == null) {
                    MergingReport.Record.Severity severity = mergeType == ManifestMerger2.MergeType.LIBRARY ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
                    xmlAttribute.addMessage(mergingReportBuilder, severity, String.format("Attribute %1$s at %2$s requires a placeholder substitution but no value for <%3$s> is provided.", xmlAttribute.getId(), xmlAttribute.printPosition(), matcher.group(2)));
                    resultString.append("${");
                    resultString.append(matcher.group(2));
                    resultString.append("}");
                } else {
                    mergingReportBuilder.getActionRecorder().recordAttributeAction(xmlAttribute, PositionImpl.UNKNOWN, Actions.ActionType.INJECTED, null);
                    resultString.append(placeholderValue);
                }
                inputString = matcher.group(3);
                matcher = PATTERN.matcher(inputString);
            }
            resultString.append(inputString);
            xmlAttribute.getXml().setValue(resultString.toString());
        }
        for (XmlElement childElement : xmlElement.getMergeableElements()) {
            this.visit(mergeType, childElement, valueProvider, mergingReportBuilder);
        }
    }

    public static interface KeyBasedValueResolver<T> {
        @Nullable
        public String getValue(@NonNull T var1);
    }
}

