/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class TestDataGuessByExistingFilesUtil {
    private TestDataGuessByExistingFilesUtil() {
    }

    @Nullable
    static List<String> collectTestDataByExistingFiles(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "collectTestDataByExistingFiles"));
        }
        if (TestDataGuessByExistingFilesUtil.getTestName(method) == null) {
            return null;
        }
        PsiFile psiFile = TestDataGuessByExistingFilesUtil.getParent((PsiElement)method, PsiFile.class);
        if (psiFile == null) {
            return null;
        }
        return TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(psiFile, TestDataGuessByExistingFilesUtil.getTestName(method.getName()));
    }

    @Nullable
    private static <T extends PsiElement> T getParent(@NotNull PsiElement element, Class<T> clazz) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getParent"));
        }
        for (PsiElement e = element; e != null; e = e.getParent()) {
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            return (T)((PsiElement)clazz.cast(e));
        }
        return null;
    }

    @Nullable
    static List<String> collectTestDataByExistingFiles(@NotNull PsiFile psiFile, @NotNull String testName) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "collectTestDataByExistingFiles"));
        }
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "collectTestDataByExistingFiles"));
        }
        TestDataDescriptor descriptor = TestDataGuessByExistingFilesUtil.buildDescriptorFromExistingTestData(psiFile);
        if (descriptor == null || !descriptor.isComplete()) {
            return null;
        }
        return descriptor.generate(testName);
    }

    @Nullable
    private static String getTestName(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getTestName"));
        }
        PsiClass psiClass = TestDataGuessByExistingFilesUtil.getParent((PsiElement)method, PsiClass.class);
        if (psiClass == null) {
            return null;
        }
        TestFramework[] frameworks = (TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME);
        TestFramework framework = null;
        for (TestFramework each : frameworks) {
            if (!each.isTestClass((PsiElement)psiClass)) continue;
            framework = each;
            break;
        }
        if (framework == null || TestDataGuessByExistingFilesUtil.isUtilityMethod(method, psiClass, framework)) {
            return null;
        }
        return TestDataGuessByExistingFilesUtil.getTestName(method.getName());
    }

    private static boolean isUtilityMethod(@NotNull PsiMethod method, @NotNull PsiClass psiClass, @NotNull TestFramework framework) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isUtilityMethod"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isUtilityMethod"));
        }
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isUtilityMethod"));
        }
        if (method == framework.findSetUpMethod((PsiElement)psiClass) || method == framework.findTearDownMethod((PsiElement)psiClass)) {
            return true;
        }
        if (framework.getClass().getName().contains("JUnit3")) {
            return !method.getName().startsWith("test");
        }
        if (framework.getClass().getName().contains("JUnit4")) {
            return !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (boolean)false);
        }
        return false;
    }

    @NotNull
    public static String getTestName(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getTestName"));
        }
        String string = StringUtil.trimStart((String)methodName, (String)"test");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getTestName"));
        }
        return string;
    }

    @Nullable
    private static TestDataDescriptor buildDescriptorFromExistingTestData(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptorFromExistingTestData"));
        }
        final PsiClass psiClass = (PsiClass)PsiTreeUtil.getChildOfType((PsiElement)file, PsiClass.class);
        if (psiClass == null) {
            return null;
        }
        TestDataDescriptor cachedValue = (TestDataDescriptor)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)new CachedValueProvider<TestDataDescriptor>(){

            @Nullable
            public CachedValueProvider.Result<TestDataDescriptor> compute() {
                return new CachedValueProvider.Result((Object)TestDataGuessByExistingFilesUtil.buildDescriptor(psiClass), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
        if (cachedValue == TestDataDescriptor.NOTHING_FOUND) {
            return null;
        }
        return cachedValue;
    }

    private static TestDataDescriptor buildDescriptor(PsiClass psiClass) {
        TestFramework[] frameworks = (TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME);
        TestFramework framework = null;
        for (TestFramework each : frameworks) {
            if (!each.isTestClass((PsiElement)psiClass)) continue;
            framework = each;
            break;
        }
        if (framework == null) {
            return TestDataDescriptor.NOTHING_FOUND;
        }
        PsiElement setUpMethod = framework.findSetUpMethod((PsiElement)psiClass);
        PsiElement tearDownMethod = framework.findTearDownMethod((PsiElement)psiClass);
        ArrayList<String> testNames = new ArrayList<String>();
        for (PsiMethod method : psiClass.getMethods()) {
            String name = TestDataGuessByExistingFilesUtil.getTestName(method.getName());
            if (StringUtil.isEmpty((String)name) || method == setUpMethod || method == tearDownMethod || name.equals(psiClass.getName()) || TestDataGuessByExistingFilesUtil.isUtilityMethod(method, psiClass, framework)) continue;
            testNames.add(name);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex();
        TestDataDescriptor descriptor = TestDataGuessByExistingFilesUtil.buildDescriptor(fileIndex, testNames, psiClass);
        if (TestDataGuessByExistingFilesUtil.isClassWithoutTestData(descriptor, testNames, psiClass)) {
            return TestDataDescriptor.NOTHING_FOUND;
        }
        return descriptor;
    }

    private static boolean isClassWithoutTestData(@NotNull TestDataDescriptor descriptor, @NotNull List<String> testNames, @NotNull PsiClass psiClass) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isClassWithoutTestData"));
        }
        if (testNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isClassWithoutTestData"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isClassWithoutTestData"));
        }
        if (testNames.size() <= 1) {
            return false;
        }
        if (!descriptor.isComplete()) {
            return true;
        }
        boolean tooGenericNames = true;
        block0: for (String testName : testNames) {
            for (int i = 0; i < testName.length(); ++i) {
                if (Character.isDigit(testName.charAt(i))) continue;
                tooGenericNames = false;
                break block0;
            }
        }
        String simpleClassName = TestDataGuessByExistingFilesUtil.getSimpleClassName(psiClass);
        if (tooGenericNames && (simpleClassName == null || !((TestLocationDescriptor)((TestDataDescriptor)descriptor).myDescriptors.get((int)0)).dir.toLowerCase().contains(simpleClassName.toLowerCase()))) {
            return true;
        }
        int toMatch = Math.max(2, testNames.size() / 2);
        block2: for (String testName : testNames) {
            if (toMatch <= 0) {
                return false;
            }
            List<String> testDataFiles = descriptor.generate(testName);
            for (String path : testDataFiles) {
                if (!new File(path).isFile()) continue;
                --toMatch;
                continue block2;
            }
        }
        return toMatch > 0;
    }

    public static List<String> suggestTestDataFiles(@NotNull ProjectFileIndex fileIndex, @NotNull String testName, String testDataPath, @NotNull PsiClass psiClass) {
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "suggestTestDataFiles"));
        }
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "suggestTestDataFiles"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "suggestTestDataFiles"));
        }
        return TestDataGuessByExistingFilesUtil.buildDescriptor(fileIndex, Collections.singletonList(testName), psiClass).generate(testName, testDataPath);
    }

    @NotNull
    private static TestDataDescriptor buildDescriptor(@NotNull ProjectFileIndex fileIndex, @NotNull Collection<String> testNames, @NotNull PsiClass psiClass) {
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptor"));
        }
        if (testNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptor"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptor"));
        }
        GotoFileModel gotoModel = new GotoFileModel(psiClass.getProject());
        HashSet testNamesLowerCase = new HashSet();
        for (String testName : testNames) {
            testNamesLowerCase.add(testName.toLowerCase());
        }
        HashSet descriptors = new HashSet();
        MultiMap<String, String> map = TestDataGuessByExistingFilesUtil.getAllFileNames(testNames, gotoModel);
        block1: for (String name : map.keySet()) {
            ProgressManager.checkCanceled();
            boolean currentNameProcessed = false;
            for (String test : map.get((Object)name)) {
                Object[] elements;
                for (Object element : elements = gotoModel.getElementsByName(name, false, name)) {
                    String filePath;
                    int i;
                    VirtualFile file;
                    if (!(element instanceof PsiFile) || (file = ((PsiFile)element).getVirtualFile()) == null || fileIndex.isInSource(file) && !fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.RESOURCES) || (i = (filePath = PathUtil.getFileName((String)file.getPath()).toLowerCase()).indexOf(test.toLowerCase())) < 0 || i + test.length() < filePath.length() && Character.isDigit(filePath.charAt(i + test.length()))) continue;
                    TestLocationDescriptor current = new TestLocationDescriptor();
                    current.populate(test, file);
                    if (!current.isComplete()) continue;
                    String prefixPattern = current.filePrefix.toLowerCase();
                    boolean checkPrefix = !StringUtil.isEmpty((String)prefixPattern);
                    String suffixPattern = current.fileSuffix;
                    for (TestLocationDescriptor descriptor : descriptors) {
                        if (!suffixPattern.endsWith(descriptor.fileSuffix)) continue;
                        suffixPattern = suffixPattern.substring(0, suffixPattern.length() - descriptor.fileSuffix.length());
                    }
                    boolean checkSuffix = !StringUtil.isEmpty((String)(suffixPattern = suffixPattern.toLowerCase()));
                    boolean skip = false;
                    for (String testName : testNamesLowerCase) {
                        if (testName.equals(test) || (!checkPrefix || !testName.startsWith(prefixPattern)) && (!checkSuffix || !testName.endsWith(suffixPattern))) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    currentNameProcessed = true;
                    if (descriptors.isEmpty() || ((TestLocationDescriptor)descriptors.iterator().next()).dir.equals(current.dir) && !descriptors.contains(current)) {
                        descriptors.add(current);
                        continue;
                    }
                    if (!TestDataGuessByExistingFilesUtil.moreRelevantPath(current, (Set<TestLocationDescriptor>)descriptors, psiClass)) continue;
                    descriptors.clear();
                    descriptors.add(current);
                }
                if (!currentNameProcessed) continue;
                continue block1;
            }
        }
        TestDataDescriptor testDataDescriptor = new TestDataDescriptor((Collection<TestLocationDescriptor>)descriptors);
        if (testDataDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptor"));
        }
        return testDataDescriptor;
    }

    private static MultiMap<String, String> getAllFileNames(final Collection<String> testNames, GotoFileModel model) {
        final LinkedMultiMap map = new LinkedMultiMap();
        model.processNames((Processor)new Processor<String>(){

            public boolean process(String name) {
                ProgressManager.checkCanceled();
                for (String testName : testNames) {
                    if (!StringUtil.containsIgnoreCase((String)name, (String)testName)) continue;
                    map.putValue((Object)name, (Object)testName);
                }
                return true;
            }
        }, false);
        return map;
    }

    @Nullable
    private static String getSimpleClassName(@NotNull PsiClass psiClass) {
        int i;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getSimpleClassName"));
        }
        String result = psiClass.getQualifiedName();
        if (result == null) {
            return null;
        }
        if (result.endsWith("Test")) {
            result = result.substring(0, result.length() - "Test".length());
        }
        if ((i = result.lastIndexOf(46)) >= 0) {
            result = result.substring(i + 1);
        }
        return result;
    }

    private static boolean moreRelevantPath(@NotNull TestLocationDescriptor candidate, @NotNull Set<TestLocationDescriptor> currentDescriptors, @NotNull PsiClass psiClass) {
        String simpleName;
        boolean currentMatched;
        boolean candidateMatched;
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "moreRelevantPath"));
        }
        if (currentDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDescriptors", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "moreRelevantPath"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "moreRelevantPath"));
        }
        String className = psiClass.getQualifiedName();
        if (className == null) {
            return false;
        }
        TestLocationDescriptor current = currentDescriptors.iterator().next();
        int i = className.lastIndexOf(".");
        if (i >= 0) {
            String packageAsPath = className.substring(0, i).replace('.', '/').toLowerCase();
            candidateMatched = candidate.dir.toLowerCase().contains(packageAsPath);
            if (candidateMatched ^ (currentMatched = current.dir.toLowerCase().contains(packageAsPath))) {
                return candidateMatched;
            }
        }
        if ((simpleName = TestDataGuessByExistingFilesUtil.getSimpleClassName(psiClass)) != null) {
            String pattern = simpleName.toLowerCase();
            candidateMatched = candidate.dir.toLowerCase().contains(pattern);
            if (candidateMatched ^ (currentMatched = current.dir.toLowerCase().contains(pattern))) {
                return candidateMatched;
            }
        }
        return false;
    }

    private static class TestDataDescriptor {
        private static final TestDataDescriptor NOTHING_FOUND = new TestDataDescriptor(Collections.<TestLocationDescriptor>emptyList());
        private final List<TestLocationDescriptor> myDescriptors = new ArrayList<TestLocationDescriptor>();

        TestDataDescriptor(Collection<TestLocationDescriptor> descriptors) {
            this.myDescriptors.addAll(descriptors);
        }

        public boolean isComplete() {
            if (this.myDescriptors.isEmpty()) {
                return false;
            }
            for (TestLocationDescriptor descriptor : this.myDescriptors) {
                if (descriptor.isComplete()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public List<String> generate(@NotNull String testName) {
            if (testName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            List<String> list = this.generate(testName, null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            return list;
        }

        @NotNull
        public List<String> generate(@NotNull String testName, String root) {
            if (testName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            ArrayList<String> result = new ArrayList<String>();
            if (StringUtil.isEmpty((String)testName)) {
                ArrayList<String> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
                }
                return arrayList;
            }
            for (TestLocationDescriptor descriptor : this.myDescriptors) {
                if (root != null && !root.equals(descriptor.dir)) continue;
                result.add(String.format("%s/%s%c%s%s.%s", descriptor.dir, descriptor.filePrefix, Character.valueOf(descriptor.startWithLowerCase ? Character.toLowerCase(testName.charAt(0)) : Character.toUpperCase(testName.charAt(0))), testName.substring(1), descriptor.fileSuffix, descriptor.ext));
            }
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            return arrayList;
        }

        public String toString() {
            return this.myDescriptors.toString();
        }
    }

    private static class TestLocationDescriptor {
        public String dir;
        public String filePrefix;
        public String fileSuffix;
        public String ext;
        public boolean startWithLowerCase;

        private TestLocationDescriptor() {
        }

        public boolean isComplete() {
            return this.dir != null && this.filePrefix != null && this.fileSuffix != null && this.ext != null;
        }

        public void populate(@NotNull String testName, @NotNull VirtualFile matched) {
            if (testName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestLocationDescriptor", "populate"));
            }
            if (matched == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matched", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestLocationDescriptor", "populate"));
            }
            String withoutExtension = FileUtil.getNameWithoutExtension((String)testName);
            boolean excludeExtension = !withoutExtension.equals(testName);
            testName = withoutExtension;
            String fileName = matched.getNameWithoutExtension();
            int i = fileName.indexOf(testName);
            char firstChar = testName.charAt(0);
            boolean testNameStartsWithLowerCase = Character.isLowerCase(firstChar);
            if (i < 0) {
                i = fileName.indexOf((testNameStartsWithLowerCase ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + testName.substring(1));
                this.startWithLowerCase = !testNameStartsWithLowerCase;
            } else {
                this.startWithLowerCase = testNameStartsWithLowerCase;
            }
            if (i < 0) {
                return;
            }
            this.filePrefix = fileName.substring(0, i);
            this.fileSuffix = fileName.substring(i + testName.length());
            this.ext = excludeExtension ? "" : matched.getExtension();
            this.dir = matched.getParent().getPath();
        }

        public int hashCode() {
            int result = this.dir != null ? this.dir.hashCode() : 0;
            result = 31 * result + (this.filePrefix != null ? this.filePrefix.hashCode() : 0);
            result = 31 * result + (this.fileSuffix != null ? this.fileSuffix.hashCode() : 0);
            result = 31 * result + (this.ext != null ? this.ext.hashCode() : 0);
            result = 31 * result + (this.startWithLowerCase ? 1 : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestLocationDescriptor that = (TestLocationDescriptor)o;
            if (this.startWithLowerCase != that.startWithLowerCase) {
                return false;
            }
            if (this.dir != null ? !this.dir.equals(that.dir) : that.dir != null) {
                return false;
            }
            if (this.ext != null ? !this.ext.equals(that.ext) : that.ext != null) {
                return false;
            }
            if (this.filePrefix != null ? !this.filePrefix.equals(that.filePrefix) : that.filePrefix != null) {
                return false;
            }
            return !(this.fileSuffix != null ? !this.fileSuffix.equals(that.fileSuffix) : that.fileSuffix != null);
        }

        public String toString() {
            return String.format("%s/%s[...]%s.%s", this.dir, this.filePrefix, this.fileSuffix, this.ext);
        }
    }
}

