/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.Location;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.testframework.TestTreeViewAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.Parameterized;
import com.intellij.ui.awt.RelativePoint;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataLineMarkerProvider;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationHandler;
import org.jetbrains.idea.devkit.testAssistant.TestDataReferenceCollector;

public class NavigateToTestDataAction
extends AnAction
implements TestTreeViewAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        List<String> fileNames = NavigateToTestDataAction.findTestDataFiles(dataContext);
        if (fileNames == null || fileNames.isEmpty()) {
            String message = "Cannot find testdata files for class";
            Notification notification = new Notification("testdata", "Found no testdata files", message, NotificationType.INFORMATION);
            Notifications.Bus.notify((Notification)notification, (Project)project);
        } else {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            RelativePoint point = editor != null ? popupFactory.guessBestPopupLocation(editor) : popupFactory.guessBestPopupLocation(dataContext);
            TestDataNavigationHandler.navigate(point, fileNames, project);
        }
    }

    @Nullable
    public static List<String> findTestDataFiles(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/testAssistant/NavigateToTestDataAction", "findTestDataFiles"));
        }
        PsiMethod method = NavigateToTestDataAction.findTargetMethod(context);
        if (method == null) {
            return null;
        }
        String name = method.getName();
        if (name.startsWith("test")) {
            String testDataPath = TestDataLineMarkerProvider.getTestDataBasePath(method.getContainingClass());
            TestDataReferenceCollector collector = new TestDataReferenceCollector(testDataPath, name.substring(4));
            return collector.collectTestDataReferences(method);
        }
        Location location = (Location)Location.DATA_KEY.getData(context);
        if (location instanceof PsiMemberParameterizedLocation) {
            PsiTypeElement operand;
            PsiAnnotationMemberValue memberValue;
            PsiAnnotation annotation;
            PsiClass containingClass = ((PsiMemberParameterizedLocation)location).getContainingClass();
            if (containingClass == null) {
                containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)location.getPsiElement(), PsiClass.class, (boolean)false);
            }
            if (containingClass != null && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)containingClass, Collections.singleton("org.junit.runner.RunWith"))) != null && (memberValue = annotation.findAttributeValue("value")) instanceof PsiClassObjectAccessExpression && (operand = ((PsiClassObjectAccessExpression)memberValue).getOperand()).getType().equalsToText(Parameterized.class.getName())) {
                String testDataPath = TestDataLineMarkerProvider.getTestDataBasePath(containingClass);
                String paramSetName = ((PsiMemberParameterizedLocation)location).getParamSetName();
                String baseFileName = StringUtil.trimEnd((String)StringUtil.trimStart((String)paramSetName, (String)"["), (String)"]");
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)containingClass.getProject()).getFileIndex();
                return TestDataGuessByExistingFilesUtil.suggestTestDataFiles(fileIndex, baseFileName, testDataPath, containingClass);
            }
        }
        return null;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(NavigateToTestDataAction.findTargetMethod(e.getDataContext()) != null);
    }

    @Nullable
    private static PsiMethod findTargetMethod(@NotNull DataContext context) {
        PsiElement element;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/testAssistant/NavigateToTestDataAction", "findTargetMethod"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file != null && editor != null) {
            PsiElement element2 = file.findElementAt(editor.getCaretModel().getOffset());
            return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiMethod.class);
        }
        Location location = (Location)Location.DATA_KEY.getData(context);
        if (location != null && (element = location.getPsiElement()) instanceof PsiMethod) {
            return (PsiMethod)element;
        }
        return null;
    }
}

