/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ChooseModulesDialog;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

abstract class AbstractRegisterFix
implements LocalQuickFix,
DescriptorUtil.Patcher {
    protected final PsiClass myClass;
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.devkit.inspections.quickfix.AbstractRegisterFix");

    public AbstractRegisterFix(PsiClass klass) {
        this.myClass = klass;
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.component.not.registered.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/AbstractRegisterFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = DevKitBundle.message("inspections.component.not.registered.quickfix.name", this.getType());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/AbstractRegisterFix", "getName"));
        }
        return string;
    }

    protected abstract String getType();

    protected static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        if (message.startsWith("java.io.IOException:")) {
            message = message.substring("java.io.IOException:".length());
        }
        return message;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/AbstractRegisterFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/quickfix/AbstractRegisterFix", "applyFix"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
            return;
        }
        PsiFile psiFile = this.myClass.getContainingFile();
        LOG.assertTrue(psiFile != null);
        final Module module = ModuleUtil.findModuleForFile((VirtualFile)psiFile.getVirtualFile(), (Project)project);
        assert (module != null);
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    if (PluginModuleType.isOfType(module)) {
                        XmlFile pluginXml = PluginModuleType.getPluginXml(module);
                        if (pluginXml != null) {
                            DescriptorUtil.patchPluginXml(AbstractRegisterFix.this, AbstractRegisterFix.this.myClass, pluginXml);
                        }
                    } else {
                        List<Module> modules = PluginModuleType.getCandidateModules(module);
                        if (modules.size() > 1) {
                            ChooseModulesDialog dialog = new ChooseModulesDialog(project, modules, AbstractRegisterFix.this.getName());
                            if (!dialog.showAndGet()) {
                                return;
                            }
                            modules = dialog.getSelectedModules();
                        }
                        XmlFile[] pluginXmls = new XmlFile[modules.size()];
                        for (int i = 0; i < pluginXmls.length; ++i) {
                            pluginXmls[i] = PluginModuleType.getPluginXml(modules.get(i));
                        }
                        DescriptorUtil.patchPluginXml(AbstractRegisterFix.this, AbstractRegisterFix.this.myClass, pluginXmls);
                    }
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                }
                catch (IncorrectOperationException e) {
                    Messages.showMessageDialog((Project)project, (String)AbstractRegisterFix.filterMessage(e.getMessage()), (String)DevKitBundle.message("inspections.component.not.registered.quickfix.error", AbstractRegisterFix.this.getType()), (Icon)Messages.getErrorIcon());
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(project, command, this.getName(), null);
    }
}

