/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.dom.Vendor;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class PluginXmlDomInspection
extends BasicDomElementsInspection<IdeaPlugin> {
    public PluginXmlDomInspection() {
        super(IdeaPlugin.class, new Class[0]);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DevKitBundle.message("inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Plugin.xml Validity" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection", "getDisplayName"));
        }
        return "Plugin.xml Validity";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("PluginXmlValidity" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection", "getShortName"));
        }
        return "PluginXmlValidity";
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        super.checkDomElement(element, holder, helper);
        if (element instanceof IdeaPlugin) {
            PluginXmlDomInspection.checkJetBrainsPlugin((IdeaPlugin)element, holder);
        } else if (element instanceof Extension) {
            PluginXmlDomInspection.annotateExtension((Extension)element, holder);
        } else if (element instanceof Vendor) {
            PluginXmlDomInspection.annotateVendor((Vendor)element, holder);
        } else if (element instanceof IdeaVersion) {
            PluginXmlDomInspection.annotateIdeaVersion((IdeaVersion)element, holder);
        } else if (element instanceof Extensions) {
            PluginXmlDomInspection.annotateExtensions((Extensions)element, holder);
        }
    }

    private static void checkJetBrainsPlugin(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder) {
        Module module = ideaPlugin.getModule();
        if (module == null) {
            return;
        }
        if (!PsiUtil.isIdeaProject(module.getProject())) {
            return;
        }
        if (ideaPlugin.getPluginId() == null) {
            return;
        }
        Vendor vendor = (Vendor)ContainerUtil.getFirstItem(ideaPlugin.getVendors());
        if (vendor == null) {
            return;
        }
        if (!"JetBrains".equals(vendor.getValue())) {
            return;
        }
        for (Extensions extensions : ideaPlugin.getExtensions()) {
            List definedEps = DomUtil.getDefinedChildrenOfType((DomElement)extensions, Extension.class, (boolean)true, (boolean)false);
            for (Extension extension : definedEps) {
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint == null || !"com.intellij.errorHandler".equals(extensionPoint.getEffectiveQualifiedName())) continue;
                return;
            }
        }
        holder.createProblem((DomElement)DomUtil.getFileElement((DomElement)ideaPlugin), "JetBrains plugin should provide <errorHandler>", new LocalQuickFix[0]);
    }

    private static void annotateExtensions(Extensions extensions, DomElementAnnotationHolder holder) {
        GenericAttributeValue<IdeaPlugin> xmlnsAttribute = extensions.getXmlns();
        if (!DomUtil.hasXml(xmlnsAttribute)) {
            return;
        }
        holder.createProblem(xmlnsAttribute, ProblemHighlightType.LIKE_DEPRECATED, "Use defaultExtensionNs instead", null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void annotateIdeaVersion(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightNotUsedAnymore(ideaVersion.getMin(), holder);
        PluginXmlDomInspection.highlightNotUsedAnymore(ideaVersion.getMax(), holder);
    }

    private static void annotateExtension(Extension extension, DomElementAnnotationHolder holder) {
        PsiClass value;
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        GenericAttributeValue<PsiClass> interfaceAttribute = extensionPoint.getInterface();
        if (DomUtil.hasXml(interfaceAttribute) && (value = (PsiClass)interfaceAttribute.getValue()) != null && value.isDeprecated()) {
            holder.createProblem((DomElement)extension, ProblemHighlightType.LIKE_DEPRECATED, "Deprecated EP", null, new LocalQuickFix[0]);
            return;
        }
        List descriptions = extension.getGenericInfo().getAttributeChildrenDescriptions();
        for (DomAttributeChildDescription attributeDescription : descriptions) {
            PsiField psiField;
            PsiElement declaration;
            GenericAttributeValue attributeValue = attributeDescription.getDomAttributeValue((DomElement)extension);
            if (attributeValue == null || !DomUtil.hasXml((DomElement)attributeValue) || !((declaration = attributeDescription.getDeclaration(extension.getManager().getProject())) instanceof PsiField) || !(psiField = (PsiField)declaration).isDeprecated()) continue;
            holder.createProblem((DomElement)attributeValue, ProblemHighlightType.LIKE_DEPRECATED, "Deprecated attribute '" + attributeDescription.getName() + "'", null, new LocalQuickFix[0]).highlightWholeElement();
        }
    }

    private static void annotateVendor(Vendor vendor, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightNotUsedAnymore(vendor.getLogo(), holder);
    }

    private static void highlightNotUsedAnymore(GenericAttributeValue attributeValue, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)attributeValue)) {
            return;
        }
        holder.createProblem((DomElement)attributeValue, ProblemHighlightType.LIKE_DEPRECATED, "Not used anymore", null, new LocalQuickFix[]{new RemoveDomElementQuickFix((DomElement)attributeValue)}).highlightWholeElement();
    }
}

