/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.lw.ComponentVisitor;
import com.intellij.uiDesigner.lw.FontDescriptor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditor;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadComponentFactory;
import com.intellij.uiDesigner.radComponents.RadGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.shared.BorderType;
import com.intellij.uiDesigner.shared.XYLayoutManager;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadContainer
extends RadComponent
implements IContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.radComponents.RadContainer");
    @NonNls
    public static final String PROP_CHILDREN = "children";
    private final ArrayList<RadComponent> myComponents;
    @NotNull
    private BorderType myBorderType;
    @Nullable
    private StringDescriptor myBorderTitle;
    private int myBorderTitleJustification;
    private int myBorderTitlePosition;
    private FontDescriptor myBorderTitleFont;
    private ColorDescriptor myBorderTitleColor;
    private Insets myBorderSize;
    private ColorDescriptor myBorderColor;
    protected RadLayoutManager myLayoutManager;
    private LayoutManager myDelegeeLayout;

    public RadContainer(ModuleProvider module, String id) {
        this(module, JPanel.class, id);
    }

    public RadContainer(ModuleProvider module, Class aClass, String id) {
        super(module, aClass, id);
        LayoutManager layoutManager;
        this.myComponents = new ArrayList();
        this.setBorderType(BorderType.NONE);
        this.myLayoutManager = this.createInitialLayoutManager();
        if (this.myLayoutManager != null && (layoutManager = this.myLayoutManager.createLayout()) != null) {
            this.setLayout(layoutManager);
        }
    }

    public RadContainer(@NotNull Class aClass, @NotNull String id, Palette palette) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/uiDesigner/radComponents/RadContainer", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/uiDesigner/radComponents/RadContainer", "<init>"));
        }
        this(null, aClass, id);
        this.setPalette(palette);
    }

    @Nullable
    protected RadLayoutManager createInitialLayoutManager() {
        String defaultLayoutManager = "GridLayoutManager";
        if (this.getModule() != null) {
            GuiDesignerConfiguration configuration = GuiDesignerConfiguration.getInstance(this.getProject());
            defaultLayoutManager = configuration.DEFAULT_LAYOUT_MANAGER;
        }
        try {
            return LayoutManagerRegistry.createLayoutManager(defaultLayoutManager);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new RadGridLayoutManager();
        }
    }

    @Override
    public Property getInplaceProperty(int x, int y) {
        Insets insets = this.getDelegee().getInsets();
        if (x < insets.left || x > this.getWidth() - insets.right || y < 0 || y > insets.top) {
            return super.getInplaceProperty(x, y);
        }
        return new MyBorderTitleProperty();
    }

    @Override
    @Nullable
    public Property getDefaultInplaceProperty() {
        return new MyBorderTitleProperty();
    }

    @Override
    @Nullable
    public Rectangle getDefaultInplaceEditorBounds() {
        return this.getBorderInPlaceEditorBounds(new MyBorderTitleProperty());
    }

    @Override
    public Rectangle getInplaceEditorBounds(Property property, int x, int y) {
        if (property instanceof MyBorderTitleProperty) {
            return this.getBorderInPlaceEditorBounds(property);
        }
        return super.getInplaceEditorBounds(property, x, y);
    }

    private Rectangle getBorderInPlaceEditorBounds(Property property) {
        MyBorderTitleProperty _property = (MyBorderTitleProperty)property;
        Insets insets = this.getDelegee().getInsets();
        return new Rectangle(insets.left, 0, this.getWidth() - insets.left - insets.right, _property.getPreferredSize().height);
    }

    public final LayoutManager getLayout() {
        if (this.myDelegeeLayout != null) {
            return this.myDelegeeLayout;
        }
        return this.getDelegee().getLayout();
    }

    public final void setLayout(LayoutManager layout) {
        this.myDelegeeLayout = layout;
        this.getDelegee().setLayout(layout);
        if (layout instanceof AbstractLayout) {
            AbstractLayout aLayout = (AbstractLayout)layout;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                RadComponent c = this.getComponent(i);
                aLayout.addLayoutComponent((Component)c.getDelegee(), (Object)c.getConstraints());
            }
        }
    }

    public final boolean isXY() {
        return this.getLayout() instanceof XYLayoutManager;
    }

    public final void addComponent(@NotNull RadComponent component, int index) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/radComponents/RadContainer", "addComponent"));
        }
        if (this.myComponents.contains(component)) {
            throw new IllegalArgumentException("component is already added: " + component);
        }
        RadComponent[] oldChildren = this.myComponents.toArray(new RadComponent[this.myComponents.size()]);
        RadContainer oldParent = component.getParent();
        if (oldParent != null) {
            oldParent.removeComponent(component);
        }
        this.myComponents.add(index, component);
        component.setParent(this);
        this.myLayoutManager.addComponentToContainer(this, component, index);
        RadComponent[] newChildren = this.myComponents.toArray(new RadComponent[this.myComponents.size()]);
        this.firePropertyChanged(PROP_CHILDREN, oldChildren, newChildren);
    }

    public final void addComponent(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/radComponents/RadContainer", "addComponent"));
        }
        this.addComponent(component, this.myComponents.size());
    }

    public final void removeComponent(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/radComponents/RadContainer", "removeComponent"));
        }
        if (!this.myComponents.contains(component)) {
            throw new IllegalArgumentException("component is not added: " + component);
        }
        RadComponent[] oldChildren = this.myComponents.toArray(new RadComponent[this.myComponents.size()]);
        component.setParent(null);
        this.myComponents.remove(component);
        this.myLayoutManager.removeComponentFromContainer(this, component);
        RadComponent[] newChildren = this.myComponents.toArray(new RadComponent[this.myComponents.size()]);
        this.firePropertyChanged(PROP_CHILDREN, oldChildren, newChildren);
    }

    public final RadComponent getComponent(int index) {
        return this.myComponents.get(index);
    }

    public final int getComponentCount() {
        return this.myComponents.size();
    }

    public int indexOfComponent(IComponent component) {
        return this.myComponents.indexOf(component);
    }

    public final RadComponent[] getComponents() {
        return this.myComponents.toArray(new RadComponent[this.myComponents.size()]);
    }

    @NotNull
    public ComponentDropLocation getDropLocation(@Nullable Point location) {
        ComponentDropLocation componentDropLocation = this.getLayoutManager().getDropLocation(this, location);
        if (componentDropLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadContainer", "getDropLocation"));
        }
        return componentDropLocation;
    }

    public RadComponent findComponentInRect(int startRow, int startCol, int rowSpan, int colSpan) {
        for (int r = startRow; r < startRow + rowSpan; ++r) {
            for (int c = startCol; c < startCol + colSpan; ++c) {
                RadComponent result = this.getComponentAtGrid(r, c);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public RadComponent getComponentAtGrid(boolean rowFirst, int coord1, int coord2) {
        return rowFirst ? this.getComponentAtGrid(coord1, coord2) : this.getComponentAtGrid(coord2, coord1);
    }

    @Nullable
    public RadComponent getComponentAtGrid(int row, int col) {
        this.getGridLayoutManager();
        return RadAbstractGridLayoutManager.getComponentAtGrid(this, row, col);
    }

    public int getGridRowCount() {
        return this.getGridLayoutManager().getGridRowCount(this);
    }

    public int getGridColumnCount() {
        return this.getGridLayoutManager().getGridColumnCount(this);
    }

    public int getGridCellCount(boolean isRow) {
        return isRow ? this.getGridRowCount() : this.getGridColumnCount();
    }

    public int getGridRowAt(int y) {
        return this.getGridLayoutManager().getGridRowAt(this, y);
    }

    public int getGridColumnAt(int x) {
        return this.getGridLayoutManager().getGridColumnAt(this, x);
    }

    @NotNull
    public final BorderType getBorderType() {
        BorderType borderType = this.myBorderType;
        if (borderType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadContainer", "getBorderType"));
        }
        return borderType;
    }

    public final void setBorderType(@NotNull BorderType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/uiDesigner/radComponents/RadContainer", "setBorderType"));
        }
        if (this.myBorderType == type) {
            return;
        }
        this.myBorderType = type;
        this.updateBorder();
    }

    @Nullable
    public final StringDescriptor getBorderTitle() {
        return this.myBorderTitle;
    }

    public final void setBorderTitle(StringDescriptor title) {
        if (Comparing.equal((Object)title, (Object)this.myBorderTitle)) {
            return;
        }
        this.myBorderTitle = title;
        this.updateBorder();
    }

    public int getBorderTitleJustification() {
        return this.myBorderTitleJustification;
    }

    public void setBorderTitleJustification(int borderTitleJustification) {
        if (this.myBorderTitleJustification != borderTitleJustification) {
            this.myBorderTitleJustification = borderTitleJustification;
            this.updateBorder();
        }
    }

    public int getBorderTitlePosition() {
        return this.myBorderTitlePosition;
    }

    public void setBorderTitlePosition(int borderTitlePosition) {
        if (this.myBorderTitlePosition != borderTitlePosition) {
            this.myBorderTitlePosition = borderTitlePosition;
            this.updateBorder();
        }
    }

    public FontDescriptor getBorderTitleFont() {
        return this.myBorderTitleFont;
    }

    public void setBorderTitleFont(FontDescriptor borderTitleFont) {
        if (!Comparing.equal((Object)this.myBorderTitleFont, (Object)borderTitleFont)) {
            this.myBorderTitleFont = borderTitleFont;
            this.updateBorder();
        }
    }

    public ColorDescriptor getBorderTitleColor() {
        return this.myBorderTitleColor;
    }

    public void setBorderTitleColor(ColorDescriptor borderTitleColor) {
        if (!Comparing.equal((Object)this.myBorderTitleColor, (Object)borderTitleColor)) {
            this.myBorderTitleColor = borderTitleColor;
            this.updateBorder();
        }
    }

    public Insets getBorderSize() {
        return this.myBorderSize;
    }

    public void setBorderSize(Insets borderSize) {
        if (!Comparing.equal((Object)this.myBorderSize, (Object)borderSize)) {
            this.myBorderSize = borderSize;
            this.updateBorder();
        }
    }

    public ColorDescriptor getBorderColor() {
        return this.myBorderColor;
    }

    public void setBorderColor(ColorDescriptor borderColor) {
        if (!Comparing.equal((Object)this.myBorderColor, (Object)borderColor)) {
            this.myBorderColor = borderColor;
            this.updateBorder();
        }
    }

    public boolean updateBorder() {
        String title = null;
        String oldTitle = null;
        if (this.myBorderTitle != null) {
            oldTitle = this.myBorderTitle.getResolvedValue();
            this.myBorderTitle.setResolvedValue(null);
            title = this.myBorderTitle.getValue() != null ? this.myBorderTitle.getValue() : StringDescriptorManager.getInstance(this.getModule()).resolve(this, this.myBorderTitle);
        }
        Font font = this.myBorderTitleFont != null ? this.myBorderTitleFont.getResolvedFont(this.getDelegee().getFont()) : null;
        Color titleColor = this.myBorderTitleColor != null ? this.myBorderTitleColor.getResolvedColor() : null;
        Color borderColor = this.myBorderColor != null ? this.myBorderColor.getResolvedColor() : null;
        this.getDelegee().setBorder(this.myBorderType.createBorder(title, this.myBorderTitleJustification, this.myBorderTitlePosition, font, titleColor, this.myBorderSize, borderColor));
        return this.myBorderTitle != null && !Comparing.equal((String)oldTitle, (String)this.myBorderTitle.getResolvedValue());
    }

    public RadLayoutManager getLayoutManager() {
        for (RadContainer parent = this; parent != null; parent = parent.getParent()) {
            if (parent.myLayoutManager == null) continue;
            return parent.myLayoutManager;
        }
        return null;
    }

    public void setLayoutManager(RadLayoutManager layoutManager) {
        this.myLayoutManager = layoutManager;
        this.setLayout(this.myLayoutManager.createLayout());
    }

    public void setLayoutManager(RadLayoutManager layoutManager, LayoutManager layout) {
        this.myLayoutManager = layoutManager;
        this.setLayout(layout);
    }

    public RadComponent getActionTargetComponent(RadComponent child) {
        return child;
    }

    @Override
    public boolean areChildrenExclusive() {
        return this.myLayoutManager.areChildrenExclusive();
    }

    @Override
    public void refresh() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).refresh();
        }
        this.myLayoutManager.refresh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBorder(XmlWriter writer) {
        writer.startElement("border");
        try {
            writer.addAttribute("type", this.getBorderType().getId());
            if (this.getBorderTitle() != null) {
                StringDescriptor descriptor = this.getBorderTitle();
                writer.writeStringDescriptor(descriptor, "title", "title-resource-bundle", "title-key");
            }
            if (this.myBorderTitleJustification != 0) {
                writer.addAttribute("title-justification", this.myBorderTitleJustification);
            }
            if (this.myBorderTitlePosition != 0) {
                writer.addAttribute("title-position", this.myBorderTitlePosition);
            }
            if (this.myBorderTitleFont != null) {
                writer.startElement("font");
                writer.writeFontDescriptor(this.myBorderTitleFont);
                writer.endElement();
            }
            if (this.myBorderTitleColor != null) {
                writer.startElement("title-color");
                writer.writeColorDescriptor(this.myBorderTitleColor);
                writer.endElement();
            }
            if (this.myBorderSize != null) {
                writer.startElement("size");
                writer.writeInsets(this.myBorderSize);
                writer.endElement();
            }
            if (this.myBorderColor != null) {
                writer.startElement("color");
                writer.writeColorDescriptor(this.myBorderColor);
                writer.endElement();
            }
        }
        finally {
            writer.endElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeChildren(XmlWriter writer) {
        writer.startElement(PROP_CHILDREN);
        try {
            this.writeChildrenImpl(writer);
        }
        finally {
            writer.endElement();
        }
    }

    protected final void writeChildrenImpl(XmlWriter writer) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).write(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(XmlWriter writer) {
        if (this.isXY()) {
            writer.startElement("xy");
        } else {
            writer.startElement("grid");
        }
        try {
            this.writeId(writer);
            this.writeClassIfDifferent(writer, JPanel.class.getName());
            this.writeBinding(writer);
            if (this.myLayoutManager != null) {
                writer.addAttribute("layout-manager", this.myLayoutManager.getName());
            }
            this.getLayoutManager().writeLayout(writer, this);
            this.writeConstraints(writer);
            this.writeProperties(writer);
            this.writeBorder(writer);
            this.writeChildren(writer);
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    public boolean accept(ComponentVisitor visitor) {
        if (!super.accept(visitor)) {
            return false;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            RadComponent c = this.getComponent(i);
            if (c.accept(visitor)) continue;
            return false;
        }
        return true;
    }

    protected void writeNoLayout(XmlWriter writer, String defaultClassName) {
        this.writeId(writer);
        this.writeClassIfDifferent(writer, defaultClassName);
        this.writeBinding(writer);
        this.writeConstraints(writer);
        this.writeProperties(writer);
        this.writeBorder(writer);
        this.writeChildren(writer);
    }

    @Override
    protected void importSnapshotComponent(SnapshotContext context, JComponent component) {
        this.getLayoutManager().createSnapshotLayout(context, component, this, component.getLayout());
        this.importSnapshotBorder(component);
        for (Component child : component.getComponents()) {
            RadComponent childComponent;
            if (!(child instanceof JComponent) || (childComponent = RadContainer.createSnapshotComponent(context, (JComponent)child)) == null) continue;
            this.getLayoutManager().addSnapshotComponent(component, (JComponent)child, this, childComponent);
        }
    }

    private void importSnapshotBorder(JComponent component) {
        Border border = component.getBorder();
        if (border != null) {
            if (border instanceof TitledBorder) {
                TitledBorder titledBorder = (TitledBorder)border;
                this.setBorderTitle(StringDescriptor.create((String)titledBorder.getTitle()));
                this.setBorderTitleJustification(titledBorder.getTitleJustification());
                this.setBorderTitlePosition(titledBorder.getTitlePosition());
                Font titleFont = titledBorder.getTitleFont();
                this.setBorderTitleFont(new FontDescriptor(titleFont.getName(), titleFont.getStyle(), titleFont.getSize()));
                this.setBorderTitleColor(new ColorDescriptor(titledBorder.getTitleColor()));
                border = titledBorder.getBorder();
            }
            if (border instanceof EtchedBorder) {
                this.setBorderType(BorderType.ETCHED);
            } else if (border instanceof BevelBorder) {
                BevelBorder bevelBorder = (BevelBorder)border;
                this.setBorderType(bevelBorder.getBevelType() == 0 ? BorderType.BEVEL_RAISED : BorderType.BEVEL_LOWERED);
            } else if (border instanceof EmptyBorder) {
                EmptyBorder emptyBorder = (EmptyBorder)border;
                this.setBorderType(BorderType.EMPTY);
                this.setBorderSize(emptyBorder.getBorderInsets());
            } else if (border instanceof LineBorder) {
                LineBorder lineBorder = (LineBorder)border;
                this.setBorderType(BorderType.LINE);
                this.setBorderColor(new ColorDescriptor(lineBorder.getLineColor()));
            }
        }
    }

    public RadAbstractGridLayoutManager getGridLayoutManager() {
        if (!(this.myLayoutManager instanceof RadAbstractGridLayoutManager)) {
            throw new RuntimeException("Not a grid container: " + this.myLayoutManager);
        }
        return (RadAbstractGridLayoutManager)this.myLayoutManager;
    }

    @Nullable
    public RadComponent findComponentWithConstraints(Object constraints) {
        for (RadComponent component : this.getComponents()) {
            if (!constraints.equals(component.getCustomLayoutConstraints())) continue;
            return component;
        }
        return null;
    }

    private final class MyBorderTitleProperty
    extends Property<RadContainer, StringDescriptor> {
        private final StringEditor myEditor;

        public MyBorderTitleProperty() {
            super(null, "Title");
            this.myEditor = new StringEditor(RadContainer.this.getProject());
        }

        public Dimension getPreferredSize() {
            return this.myEditor.getPreferredSize();
        }

        @Override
        public StringDescriptor getValue(RadContainer component) {
            return RadContainer.this.myBorderTitle;
        }

        @Override
        protected void setValueImpl(RadContainer container, StringDescriptor value) throws Exception {
            RadContainer.this.setBorderTitle(value);
        }

        @Override
        @NotNull
        public PropertyRenderer<StringDescriptor> getRenderer() {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadContainer$MyBorderTitleProperty", "getRenderer"));
            }
            return null;
        }

        @Override
        public PropertyEditor<StringDescriptor> getEditor() {
            return this.myEditor;
        }
    }

    public static class Factory
    extends RadComponentFactory {
        @Override
        public RadComponent newInstance(ModuleProvider module, Class aClass, String id) {
            return new RadContainer(module, aClass, id);
        }

        @Override
        public RadComponent newInstance(Class componentClass, String id, Palette palette) {
            return new RadContainer(componentClass, id, palette);
        }
    }
}

