/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import java.util.ArrayList;
import javax.swing.Icon;

public class AddGroupAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        String groupName = Messages.showInputDialog((Project)project, (String)UIDesignerBundle.message("message.enter.group.name", new Object[0]), (String)UIDesignerBundle.message("title.add.group", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (groupName == null) {
            return;
        }
        Palette palette = Palette.getInstance(project);
        ArrayList<GroupItem> groups = palette.getGroups();
        for (int i = groups.size() - 1; i >= 0; --i) {
            if (!groupName.equals(groups.get(i).getName())) continue;
            Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("error.group.name.unique", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        GroupItem groupToBeAdded = new GroupItem(groupName);
        ArrayList<GroupItem> newGroups = new ArrayList<GroupItem>(groups);
        newGroups.add(groupToBeAdded);
        palette.setGroups(newGroups);
    }
}

