/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.compiler.Utils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FormRelatedFilesProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        block11: {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/uiDesigner/binding/FormRelatedFilesProvider", "getItems"));
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class, (boolean)false);
            if (psiClass != null) {
                while (psiClass != null) {
                    List<PsiFile> forms = FormClassIndex.findFormsBoundToClass(psiClass.getProject(), psiClass);
                    if (!forms.isEmpty()) {
                        List list = GotoRelatedItem.createItems(forms, (String)"UI Forms");
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormRelatedFilesProvider", "getItems"));
                        }
                        return list;
                    }
                    psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
                }
            } else {
                PsiFile file = context.getContainingFile();
                if (file != null && file.getFileType() == GuiFormFileType.INSTANCE) {
                    List<GotoRelatedItem> list;
                    try {
                        Project project;
                        PsiClass aClass;
                        String className = Utils.getBoundClassName((String)file.getText());
                        if (className == null || (aClass = JavaPsiFacade.getInstance((Project)(project = file.getProject())).findClass(className, GlobalSearchScope.allScope((Project)project))) == null) break block11;
                        list = Collections.singletonList(new GotoRelatedItem((PsiElement)aClass, "Java"));
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormRelatedFilesProvider", "getItems"));
                    }
                    return list;
                }
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormRelatedFilesProvider", "getItems"));
        }
        return list;
    }
}

