/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.impl.dir.FrameDialogWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TabbedPaneImpl;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDiffPanel;
import git4idea.ui.branch.GitCompareBranchesLogPanel;
import git4idea.util.GitCommitCompareInfo;
import icons.VcsLogIcons;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCompareBranchesDialog
extends FrameDialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JPanel myLogPanel;
    @NotNull
    private final TabbedPaneImpl myTabbedPane;
    @NotNull
    private final String myTitle;
    @NotNull
    private final FrameDialogWrapper.Mode myMode;

    public GitCompareBranchesDialog(@NotNull Project project, @NotNull String branchName, @NotNull String currentBranchName, @NotNull GitCommitCompareInfo compareInfo, @NotNull GitRepository initialRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (currentBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranchName", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (compareInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compareInfo", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (initialRepo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialRepo", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        this(project, branchName, currentBranchName, compareInfo, initialRepo, false);
    }

    public GitCompareBranchesDialog(@NotNull Project project, @NotNull String branchName, @NotNull String currentBranchName, @NotNull GitCommitCompareInfo compareInfo, @NotNull GitRepository initialRepo, boolean dialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (currentBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranchName", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (compareInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compareInfo", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (initialRepo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialRepo", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        this.myProject = project;
        String rootString = compareInfo.getRepositories().size() == 1 && GitUtil.getRepositoryManager(this.myProject).moreThanOneRoot() ? " in root " + DvcsUtil.getShortRepositoryName((Repository)initialRepo) : "";
        this.myTitle = String.format("Comparing %s with %s%s", currentBranchName, branchName, rootString);
        this.myMode = dialog ? FrameDialogWrapper.Mode.MODAL : FrameDialogWrapper.Mode.FRAME;
        GitCompareBranchesDiffPanel diffPanel = new GitCompareBranchesDiffPanel(this.myProject, branchName, currentBranchName, compareInfo);
        this.myLogPanel = new GitCompareBranchesLogPanel(this.myProject, branchName, currentBranchName, compareInfo, initialRepo);
        this.myTabbedPane = new TabbedPaneImpl(1);
        this.myTabbedPane.addTab("Log", VcsLogIcons.Branch, (Component)this.myLogPanel);
        this.myTabbedPane.addTab("Diff", AllIcons.Actions.Diff, (Component)diffPanel);
        this.myTabbedPane.setKeyboardNavigation(TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS);
    }

    @NotNull
    protected JComponent getPanel() {
        TabbedPaneImpl tabbedPaneImpl = this.myTabbedPane;
        if (tabbedPaneImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitCompareBranchesDialog", "getPanel"));
        }
        return tabbedPaneImpl;
    }

    @Nullable
    protected JComponent getPreferredFocusedComponent() {
        return this.myLogPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return GitCompareBranchesDialog.class.getName();
    }

    @NotNull
    protected String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitCompareBranchesDialog", "getTitle"));
        }
        return string;
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitCompareBranchesDialog", "getProject"));
        }
        return project;
    }

    @NotNull
    protected FrameDialogWrapper.Mode getMode() {
        FrameDialogWrapper.Mode mode = this.myMode;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitCompareBranchesDialog", "getMode"));
        }
        return mode;
    }
}

