/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsBranchPopup;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopup
extends DvcsBranchPopup<GitRepository> {
    static GitBranchPopup getInstance(@NotNull Project project, @NotNull GitRepository currentRepository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopup", "getInstance"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/ui/branch/GitBranchPopup", "getInstance"));
        }
        final GitVcsSettings vcsSettings = GitVcsSettings.getInstance(project);
        Condition<AnAction> preselectActionCondition = new Condition<AnAction>(){

            public boolean value(AnAction action) {
                if (action instanceof GitBranchPopupActions.LocalBranchActions) {
                    GitBranchPopupActions.LocalBranchActions branchAction = (GitBranchPopupActions.LocalBranchActions)action;
                    String branchName = branchAction.getBranchName();
                    List<GitRepository> repositories = branchAction.getRepositories();
                    String recentBranch = repositories.size() == 1 ? vcsSettings.getRecentBranchesByRepository().get(repositories.iterator().next().getRoot().getPath()) : vcsSettings.getRecentCommonBranch();
                    if (recentBranch != null && recentBranch.equals(branchName)) {
                        return true;
                    }
                }
                return false;
            }
        };
        return new GitBranchPopup(currentRepository, GitUtil.getRepositoryManager(project), vcsSettings, preselectActionCondition);
    }

    private GitBranchPopup(@NotNull GitRepository currentRepository, @NotNull GitRepositoryManager repositoryManager, @NotNull GitVcsSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition) {
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        if (vcsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsSettings", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        if (preselectActionCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectActionCondition", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        super((Repository)currentRepository, (AbstractRepositoryManager)repositoryManager, (DvcsMultiRootBranchConfig)new GitMultiRootBranchConfig(repositoryManager.getRepositories()), (DvcsSyncSettings)vcsSettings, preselectActionCondition);
    }

    protected void setCurrentBranchInfo() {
        String currentBranchText = "Current branch";
        currentBranchText = this.myRepositoryManager.moreThanOneRoot() ? (this.myMultiRootBranchConfig.diverged() ? currentBranchText + " in " + DvcsUtil.getShortRepositoryName((Repository)this.myCurrentRepository) + ": " + GitBranchUtil.getDisplayableBranchText((GitRepository)this.myCurrentRepository) : currentBranchText + ": " + this.myMultiRootBranchConfig.getCurrentBranch()) : currentBranchText + ": " + GitBranchUtil.getDisplayableBranchText((GitRepository)this.myCurrentRepository);
        this.myPopup.setAdText(currentBranchText, 0);
    }

    protected void fillWithCommonRepositoryActions(@NotNull DefaultActionGroup popupGroup, @NotNull AbstractRepositoryManager<GitRepository> repositoryManager) {
        if (popupGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupGroup", "git4idea/ui/branch/GitBranchPopup", "fillWithCommonRepositoryActions"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/ui/branch/GitBranchPopup", "fillWithCommonRepositoryActions"));
        }
        List allRepositories = repositoryManager.getRepositories();
        popupGroup.add((AnAction)new GitBranchPopupActions.GitNewBranchAction(this.myProject, allRepositories));
        popupGroup.addAll((ActionGroup)this.createRepositoriesActions());
        popupGroup.addSeparator("Common Local Branches");
        for (String branch : this.myMultiRootBranchConfig.getLocalBranchNames()) {
            List repositories = this.filterRepositoriesNotOnThisBranch(branch, allRepositories);
            if (repositories.isEmpty()) continue;
            popupGroup.add((AnAction)new GitBranchPopupActions.LocalBranchActions(this.myProject, repositories, branch, (GitRepository)this.myCurrentRepository));
        }
        popupGroup.addSeparator("Common Remote Branches");
        for (String branch : ((GitMultiRootBranchConfig)this.myMultiRootBranchConfig).getRemoteBranches()) {
            popupGroup.add((AnAction)new GitBranchPopupActions.RemoteBranchActions(this.myProject, allRepositories, branch, (GitRepository)this.myCurrentRepository));
        }
    }

    @NotNull
    protected DefaultActionGroup createRepositoriesActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        popupGroup.addSeparator("Repositories");
        for (GitRepository repository : DvcsUtil.sortRepositories((Collection)this.myRepositoryManager.getRepositories())) {
            popupGroup.add((AnAction)new RootAction((Repository)repository, (Repository)(this.highlightCurrentRepo() ? (GitRepository)this.myCurrentRepository : null), new GitBranchPopupActions(repository.getProject(), repository).createActions(null), GitBranchUtil.getDisplayableBranchText(repository)));
        }
        DefaultActionGroup defaultActionGroup = popupGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopup", "createRepositoriesActions"));
        }
        return defaultActionGroup;
    }

    protected void fillPopupWithCurrentRepositoryActions(@NotNull DefaultActionGroup popupGroup, @Nullable DefaultActionGroup actions) {
        if (popupGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupGroup", "git4idea/ui/branch/GitBranchPopup", "fillPopupWithCurrentRepositoryActions"));
        }
        popupGroup.addAll(new GitBranchPopupActions(((GitRepository)this.myCurrentRepository).getProject(), (GitRepository)this.myCurrentRepository).createActions(actions));
    }
}

