/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.repo.GitRepositoryImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryCreator
extends VcsRepositoryCreator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitPlatformFacade myPlatformFacade;

    public GitRepositoryCreator(@NotNull Project project, @NotNull GitPlatformFacade platformFacade) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryCreator", "<init>"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/repo/GitRepositoryCreator", "<init>"));
        }
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
    }

    @Nullable
    public Repository createRepositoryIfValid(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/repo/GitRepositoryCreator", "createRepositoryIfValid"));
        }
        return GitUtil.isGitRoot(new File(root.getPath())) ? GitRepositoryImpl.getFullInstance(root, this.myProject, this.myPlatformFacade, (Disposable)this.myProject) : null;
    }

    @NotNull
    public VcsKey getVcsKey() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryCreator", "getVcsKey"));
        }
        return vcsKey;
    }
}

