/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.merge.GitMergeUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;

public class GitMerger {
    private final Project myProject;
    private final GitVcs myVcs;

    public GitMerger(Project project) {
        this.myProject = project;
        this.myVcs = GitVcs.getInstance(project);
    }

    public Collection<VirtualFile> getMergingRoots() {
        HashSet<VirtualFile> mergingRoots = new HashSet<VirtualFile>();
        for (VirtualFile root : ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)this.myVcs)) {
            if (!GitMergeUtil.isMergeInProgress(root)) continue;
            mergingRoots.add(root);
        }
        return mergingRoots;
    }

    public void mergeCommit(Collection<VirtualFile> roots) throws VcsException {
        for (VirtualFile root : roots) {
            this.mergeCommit(root);
        }
    }

    public void mergeCommit(VirtualFile root) throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        File gitDir = new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), ".git");
        File messageFile = new File(gitDir, "MERGE_MSG");
        if (!messageFile.exists()) {
            GitLocalBranch branch = GitBranchUtil.getCurrentBranch(this.myProject, root);
            String branchName = branch != null ? branch.getName() : "";
            handler.addParameters("-m", "Merge branch '" + branchName + "' of " + root.getPresentableUrl() + " with conflicts.");
        } else {
            handler.addParameters("-F", messageFile.getAbsolutePath());
        }
        handler.endOptions();
        handler.run();
    }
}

