/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.ide.passwordSafe.MasterPasswordUnavailableException;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.ui.PasswordSafePromptDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AuthData;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.AuthDialog;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.remote.GitRememberedInputs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitHttpGuiAuthenticator
implements GitHttpAuthenticator {
    private static final Logger LOG = Logger.getInstance(GitHttpGuiAuthenticator.class);
    private static final Class<GitHttpAuthenticator> PASS_REQUESTER = GitHttpAuthenticator.class;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myUrlFromCommand;
    @Nullable
    private String myPassword;
    @Nullable
    private String myPasswordKey;
    @Nullable
    private String myUrl;
    @Nullable
    private String myLogin;
    private boolean mySaveOnDisk;
    @Nullable
    private GitHttpAuthDataProvider myDataProvider;
    private boolean myWasCancelled;

    GitHttpGuiAuthenticator(@NotNull Project project, @NotNull GitCommand command, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitHttpGuiAuthenticator", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "git4idea/commands/GitHttpGuiAuthenticator", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator", "<init>"));
        }
        this.myProject = project;
        this.myTitle = "Git " + StringUtil.capitalize((String)command.name());
        this.myUrlFromCommand = url;
    }

    @Override
    @NotNull
    public String askPassword(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator", "askPassword"));
        }
        if (this.myPassword != null) {
            String string = this.myPassword;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "askPassword"));
            }
            return string;
        }
        if (this.myWasCancelled) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "askPassword"));
            }
            return "";
        }
        Pair<GitHttpAuthDataProvider, AuthData> authData = this.findBestAuthData(url = this.adjustUrl(url));
        if (authData != null && ((AuthData)authData.second).getPassword() != null) {
            String password = ((AuthData)authData.second).getPassword();
            this.myDataProvider = (GitHttpAuthDataProvider)authData.first;
            this.myPassword = password;
            String string = password;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "askPassword"));
            }
            return string;
        }
        String prompt = "Enter the password for " + url;
        this.myPasswordKey = url;
        String password = PasswordSafePromptDialog.askPassword((Project)this.myProject, (String)this.myTitle, (String)prompt, PASS_REQUESTER, (String)url, (boolean)false, null);
        if (password == null) {
            this.myWasCancelled = true;
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "askPassword"));
            }
            return "";
        }
        this.myPassword = password;
        this.myDataProvider = new GitDefaultHttpAuthDataProvider();
        String string = password;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "askPassword"));
        }
        return string;
    }

    @Override
    @NotNull
    public String askUsername(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator", "askUsername"));
        }
        url = this.adjustUrl(url);
        Pair<GitHttpAuthDataProvider, AuthData> authData = this.findBestAuthData(url);
        String login = null;
        String password = null;
        if (authData != null) {
            login = ((AuthData)authData.second).getLogin();
            password = ((AuthData)authData.second).getPassword();
            this.myDataProvider = (GitHttpAuthDataProvider)authData.first;
        }
        if (login != null && password != null) {
            this.myPassword = password;
            String string = login;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "askUsername"));
            }
            return string;
        }
        AuthDialog dialog = this.showAuthDialog(url, login);
        if (dialog == null || !dialog.isOK()) {
            this.myWasCancelled = true;
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "askUsername"));
            }
            return "";
        }
        this.myPassword = dialog.getPassword();
        this.myLogin = dialog.getUsername();
        this.myUrl = url;
        this.mySaveOnDisk = dialog.isRememberPassword();
        this.myPasswordKey = GitHttpGuiAuthenticator.makeKey(this.myUrl, this.myLogin);
        String string = this.myLogin;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "askUsername"));
        }
        return string;
    }

    @Nullable
    private AuthDialog showAuthDialog(final String url, final String login) {
        final Ref dialog = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                dialog.set((Object)new AuthDialog(GitHttpGuiAuthenticator.this.myProject, GitHttpGuiAuthenticator.this.myTitle, "Enter credentials for " + url, login, null, true));
                ((AuthDialog)dialog.get()).show();
            }
        }, ModalityState.any());
        return (AuthDialog)dialog.get();
    }

    @Override
    public void saveAuthData() {
        if (this.myUrl != null && this.myLogin != null) {
            GitRememberedInputs.getInstance().addUrl(this.myUrl, this.myLogin);
        }
        if (this.myPasswordKey != null && this.myPassword != null) {
            PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
            try {
                passwordSafe.getMemoryProvider().storePassword(this.myProject, PASS_REQUESTER, this.myPasswordKey, this.myPassword);
                if (this.mySaveOnDisk) {
                    passwordSafe.getMasterKeyProvider().storePassword(this.myProject, PASS_REQUESTER, this.myPasswordKey, this.myPassword);
                }
            }
            catch (MasterPasswordUnavailableException ignored) {
            }
            catch (PasswordSafeException e) {
                LOG.error("Couldn't remember password for " + this.myPasswordKey, (Throwable)e);
            }
        }
    }

    @Override
    public void forgetPassword() {
        if (this.myDataProvider != null) {
            this.myDataProvider.forgetPassword(this.adjustUrl(this.myUrl));
        }
    }

    @Override
    public boolean wasCancelled() {
        return this.myWasCancelled;
    }

    @NotNull
    private String adjustUrl(@Nullable String url) {
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            String string = GitHttpGuiAuthenticator.adjustHttpUrl(GitHttpGuiAuthenticator.getHost(this.myUrlFromCommand));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "adjustUrl"));
            }
            return string;
        }
        String string = GitHttpGuiAuthenticator.adjustHttpUrl(url);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "adjustUrl"));
        }
        return string;
    }

    @NotNull
    private static String getHost(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator", "getHost"));
        }
        Couple split = UriUtil.splitScheme((String)url);
        String scheme = (String)split.getFirst();
        String urlItself = (String)split.getSecond();
        int pathStart = urlItself.indexOf("/");
        String string = scheme + "://" + urlItself.substring(0, pathStart);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "getHost"));
        }
        return string;
    }

    @NotNull
    private static String adjustHttpUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator", "adjustHttpUrl"));
        }
        String prefix = "https";
        if (url.startsWith(prefix)) {
            String string = "http" + url.substring(prefix.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "adjustHttpUrl"));
            }
            return string;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "adjustHttpUrl"));
        }
        return string;
    }

    @Nullable
    private Pair<GitHttpAuthDataProvider, AuthData> findBestAuthData(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator", "findBestAuthData"));
        }
        Pair candidate = null;
        for (GitHttpAuthDataProvider provider : this.getProviders()) {
            AuthData data = provider.getAuthData(url);
            if (data == null) continue;
            Pair pair = Pair.create((Object)provider, (Object)data);
            if (data.getPassword() != null) {
                return pair;
            }
            if (candidate != null) continue;
            candidate = pair;
        }
        return candidate;
    }

    @NotNull
    private List<GitHttpAuthDataProvider> getProviders() {
        ArrayList providers = ContainerUtil.newArrayList();
        providers.add(new GitDefaultHttpAuthDataProvider());
        providers.addAll(Arrays.asList(GitHttpAuthDataProvider.EP_NAME.getExtensions()));
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "getProviders"));
        }
        return arrayList;
    }

    @NotNull
    private static String makeKey(@NotNull String url, @Nullable String login) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator", "makeKey"));
        }
        if (login == null) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "makeKey"));
            }
            return string;
        }
        Couple pair = UriUtil.splitScheme((String)url);
        String scheme = (String)pair.getFirst();
        if (StringUtil.isEmpty((String)scheme)) {
            String string = scheme + "://" + login + "@" + (String)pair.getSecond();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "makeKey"));
            }
            return string;
        }
        String string = login + "@" + url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHttpGuiAuthenticator", "makeKey"));
        }
        return string;
    }

    public class GitDefaultHttpAuthDataProvider
    implements GitHttpAuthDataProvider {
        @Override
        @Nullable
        public AuthData getAuthData(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator$GitDefaultHttpAuthDataProvider", "getAuthData"));
            }
            String userName = this.getUsername(url);
            String key = GitHttpGuiAuthenticator.makeKey(url, userName);
            PasswordSafe passwordSafe = PasswordSafe.getInstance();
            try {
                String password = passwordSafe.getPassword(GitHttpGuiAuthenticator.this.myProject, PASS_REQUESTER, key);
                return new AuthData(StringUtil.notNullize((String)userName), password);
            }
            catch (PasswordSafeException e) {
                LOG.info("Couldn't get the password for key [" + key + "]", (Throwable)e);
                return null;
            }
        }

        @Nullable
        private String getUsername(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator$GitDefaultHttpAuthDataProvider", "getUsername"));
            }
            return GitRememberedInputs.getInstance().getUserNameForUrl(url);
        }

        @Override
        public void forgetPassword(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator$GitDefaultHttpAuthDataProvider", "forgetPassword"));
            }
            String key = GitHttpGuiAuthenticator.this.myPasswordKey != null ? GitHttpGuiAuthenticator.this.myPasswordKey : GitHttpGuiAuthenticator.makeKey(url, this.getUsername(url));
            try {
                PasswordSafe.getInstance().removePassword(GitHttpGuiAuthenticator.this.myProject, PASS_REQUESTER, key);
            }
            catch (PasswordSafeException e) {
                LOG.info("Couldn't forget the password for " + GitHttpGuiAuthenticator.this.myPasswordKey);
            }
        }
    }
}

