/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommandResult {
    private final boolean mySuccess;
    private final int myExitCode;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;
    @Nullable
    private final Throwable myException;

    public GitCommandResult(boolean success, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output, @Nullable Throwable exception) {
        if (errorOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutput", "git4idea/commands/GitCommandResult", "<init>"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/commands/GitCommandResult", "<init>"));
        }
        this.myExitCode = exitCode;
        this.mySuccess = success;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
        this.myException = exception;
    }

    public boolean success() {
        return this.mySuccess;
    }

    @NotNull
    public List<String> getOutput() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myOutput);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "getOutput"));
        }
        return arrayList;
    }

    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    @NotNull
    public String getErrorOutputAsHtmlString() {
        String string = StringUtil.join(GitCommandResult.cleanup(this.myErrorOutput), (String)"<br/>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "getErrorOutputAsHtmlString"));
        }
        return string;
    }

    @NotNull
    public String getErrorOutputAsJoinedString() {
        String string = StringUtil.join(this.myErrorOutput, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "getErrorOutputAsJoinedString"));
        }
        return string;
    }

    @NotNull
    public String getOutputAsJoinedString() {
        String string = StringUtil.join(this.myOutput, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "getOutputAsJoinedString"));
        }
        return string;
    }

    @Nullable
    public Throwable getException() {
        return this.myException;
    }

    @NotNull
    public static GitCommandResult error(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "git4idea/commands/GitCommandResult", "error"));
        }
        GitCommandResult gitCommandResult = new GitCommandResult(false, 1, Collections.singletonList(error), Collections.<String>emptyList(), null);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "error"));
        }
        return gitCommandResult;
    }

    public boolean cancelled() {
        return false;
    }

    @NotNull
    private static Collection<String> cleanup(@NotNull Collection<String> errorOutput) {
        if (errorOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutput", "git4idea/commands/GitCommandResult", "cleanup"));
        }
        List list = ContainerUtil.map(errorOutput, (Function)new Function<String, String>(){

            public String fun(String errorMessage) {
                return GitUtil.cleanupErrorPrefixes(errorMessage);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "cleanup"));
        }
        return list;
    }
}

