/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import java.util.Collection;
import java.util.Date;

public class GitCommittedChangeList
extends CommittedChangeListImpl
implements VcsRevisionNumberAware {
    private final GitRevisionNumber myRevisionNumber;
    private final boolean myModifiable;

    public GitCommittedChangeList(String name, String comment, String committerName, GitRevisionNumber revisionNumber, Date commitDate, Collection<Change> changes, boolean isModifiable) {
        super(name, comment, committerName, GitChangeUtils.longForSHAHash(revisionNumber.asString()), commitDate, changes);
        this.myRevisionNumber = revisionNumber;
        this.myModifiable = isModifiable;
    }

    public boolean isModifiable() {
        return this.myModifiable;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }
}

