/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.Bitness;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JdkVersionDetector {
    public static JdkVersionDetector getInstance() {
        return JpsServiceManager.getInstance().getService(JdkVersionDetector.class);
    }

    @Nullable
    public abstract String detectJdkVersion(String var1);

    @Nullable
    public abstract String detectJdkVersion(String var1, ActionRunner var2);

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(String var1);

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(String var1, ActionRunner var2);

    @Deprecated
    @Nullable
    public abstract String readVersionFromProcessOutput(String var1, String[] var2, String var3, ActionRunner var4);

    public static final class JdkVersionInfo {
        private final String myVersion;
        private final Bitness myBitness;

        public JdkVersionInfo(@NotNull String version, @NotNull Bitness bitness) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo", "<init>"));
            }
            if (bitness == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bitness", "org/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo", "<init>"));
            }
            this.myVersion = version;
            this.myBitness = bitness;
        }

        @NotNull
        public String getVersion() {
            String string = this.myVersion;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo", "getVersion"));
            }
            return string;
        }

        @NotNull
        public Bitness getBitness() {
            Bitness bitness = this.myBitness;
            if (bitness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo", "getBitness"));
            }
            return bitness;
        }
    }

    public static interface ActionRunner {
        public Future<?> run(Runnable var1);
    }
}

