/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.Where;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskDescriptor {
    private boolean myHaveMagicCure;
    private final String myName;
    @NotNull
    private final Where myWhere;
    private final Map<Object, Object> mySurviveKit;

    public TaskDescriptor(String name, @NotNull Where where) {
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/util/continuation/TaskDescriptor", "<init>"));
        }
        this.myName = name;
        this.myWhere = where;
        this.mySurviveKit = new HashMap<Object, Object>();
    }

    public abstract void run(ContinuationContext var1);

    public final void addCure(Object disaster, Object cure) {
        this.mySurviveKit.put(disaster, cure);
    }

    @Nullable
    public final Object hasCure(Object disaster) {
        return this.mySurviveKit.get(disaster);
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public Where getWhere() {
        Where where = this.myWhere;
        if (where == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/continuation/TaskDescriptor", "getWhere"));
        }
        return where;
    }

    public boolean isHaveMagicCure() {
        return this.myHaveMagicCure;
    }

    public void setHaveMagicCure(boolean haveMagicCure) {
        this.myHaveMagicCure = haveMagicCure;
    }

    public void canceled() {
    }

    public static TaskDescriptor createForBackgroundableTask(final @NotNull Task.Backgroundable backgroundable) {
        if (backgroundable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundable", "com/intellij/util/continuation/TaskDescriptor", "createForBackgroundableTask"));
        }
        return new TaskDescriptor(backgroundable.getTitle(), Where.POOLED){

            @Override
            public void run(ContinuationContext context) {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                try {
                    backgroundable.run(indicator);
                }
                catch (ProcessCanceledException e) {
                    // empty catch block
                }
                final boolean canceled = indicator.isCanceled();
                context.next(new TaskDescriptor("", Where.AWT){

                    @Override
                    public void run(ContinuationContext context) {
                        if (canceled) {
                            backgroundable.onCancel();
                        } else {
                            backgroundable.onSuccess();
                        }
                    }
                });
            }
        };
    }
}

