/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nullable;

public class PlatformUtils {
    public static final String PLATFORM_PREFIX_KEY = "idea.platform.prefix";
    public static final String IDEA_PREFIX = "idea";
    public static final String IDEA_CE_PREFIX = "Idea";
    public static final String APPCODE_PREFIX = "AppCode";
    public static final String CLION_PREFIX = "CLion";
    public static final String PYCHARM_PREFIX = "Python";
    public static final String PYCHARM_CE_PREFIX = "PyCharmCore";
    public static final String PYCHARM_EDU_PREFIX = "PyCharmEdu";
    public static final String RUBY_PREFIX = "Ruby";
    public static final String PHP_PREFIX = "PhpStorm";
    public static final String WEB_PREFIX = "WebStorm";
    public static final String DBE_PREFIX = "0xDBE";
    public static final String COMMUNITY_PREFIX = "Idea";
    public static final String PYCHARM_PREFIX2 = "PyCharmCore";
    public static final String FLEX_PREFIX = "Flex";

    public static String getPlatformPrefix() {
        return PlatformUtils.getPlatformPrefix(IDEA_PREFIX);
    }

    public static String getPlatformPrefix(String defaultPrefix) {
        return System.getProperty(PLATFORM_PREFIX_KEY, defaultPrefix);
    }

    public static boolean isIntelliJ() {
        return PlatformUtils.isIdea() || PlatformUtils.isCommunity();
    }

    public static boolean isIdeaUltimate() {
        return PlatformUtils.is(IDEA_PREFIX);
    }

    public static boolean isIdeaCommunity() {
        return PlatformUtils.is("Idea");
    }

    public static boolean isRubyMine() {
        return PlatformUtils.is(RUBY_PREFIX);
    }

    public static boolean isAppCode() {
        return PlatformUtils.is(APPCODE_PREFIX);
    }

    public static boolean isCLion() {
        return PlatformUtils.is(CLION_PREFIX);
    }

    public static boolean isCidr() {
        return PlatformUtils.isAppCode() || PlatformUtils.isCLion();
    }

    public static boolean isPyCharm() {
        return PlatformUtils.isPyCharmPro() || PlatformUtils.isPyCharmCommunity() || PlatformUtils.isPyCharmEducational();
    }

    public static boolean isPyCharmPro() {
        return PlatformUtils.is(PYCHARM_PREFIX);
    }

    public static boolean isPyCharmCommunity() {
        return PlatformUtils.is("PyCharmCore");
    }

    public static boolean isPyCharmEducational() {
        return PlatformUtils.is(PYCHARM_EDU_PREFIX);
    }

    public static boolean isPhpStorm() {
        return PlatformUtils.is(PHP_PREFIX);
    }

    public static boolean isWebStorm() {
        return PlatformUtils.is(WEB_PREFIX);
    }

    public static boolean isDatabaseIDE() {
        return PlatformUtils.is(DBE_PREFIX);
    }

    public static boolean isCommunityEdition() {
        return PlatformUtils.isIdeaCommunity() || PlatformUtils.isPyCharmCommunity();
    }

    private static boolean is(String idePrefix) {
        return idePrefix.equals(PlatformUtils.getPlatformPrefix());
    }

    public static boolean isIdeaProject(@Nullable Project project) {
        return false;
    }

    public static boolean isIdea() {
        return PlatformUtils.isIdeaUltimate();
    }

    public static boolean isCommunity() {
        return PlatformUtils.isIdeaCommunity();
    }

    public static boolean isFlexIde() {
        return false;
    }
}

