/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellRenderer
implements TableCellRenderer,
ClientPropertyHolder {
    private final TreeTable myTreeTable;
    private final TreeTableTree myTree;
    private TreeCellRenderer myTreeCellRenderer;
    private Border myDefaultBorder = UIUtil.getTableFocusCellHighlightBorder();

    public TreeTableCellRenderer(TreeTable treeTable, TreeTableTree tree) {
        this.myTreeTable = treeTable;
        this.myTree = tree;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelRow = table.convertRowIndexToModel(row);
        if (this.myTreeCellRenderer != null) {
            this.myTree.setCellRenderer(this.myTreeCellRenderer);
        }
        if (isSelected) {
            this.myTree.setBackground(table.getSelectionBackground());
            this.myTree.setForeground(table.getSelectionForeground());
        } else {
            this.myTree.setBackground(table.getBackground());
            this.myTree.setForeground(table.getForeground());
        }
        this.myTree.setVisibleRow(modelRow);
        Object treeObject = this.myTree.getPathForRow(modelRow).getLastPathComponent();
        boolean leaf = this.myTree.getModel().isLeaf(treeObject);
        boolean expanded = this.myTree.isExpanded(modelRow);
        Component component = this.myTree.getCellRenderer().getTreeCellRendererComponent(this.myTree, treeObject, isSelected, expanded, leaf, modelRow, hasFocus);
        if (component instanceof JComponent) {
            table.setToolTipText(((JComponent)component).getToolTipText());
        }
        return this.myTree;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.myTreeCellRenderer = treeCellRenderer;
    }

    public void setDefaultBorder(Border border) {
        this.myDefaultBorder = border;
    }

    public void putClientProperty(String key, Object value) {
        this.myTree.putClientProperty(key, value);
    }

    public void putClientProperty(String s, String s1) {
        this.putClientProperty(s, (Object)s1);
    }

    public void setRootVisible(boolean b) {
        this.myTree.setRootVisible(b);
    }

    public void setShowsRootHandles(boolean b) {
        this.myTree.setShowsRootHandles(b);
    }
}

