/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.switcher.QuickAccessSettings;
import com.intellij.ui.switcher.SwitchManager;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchingSession;
import java.awt.event.KeyEvent;

public abstract class SwitchAction
extends AnAction
implements DumbAware {
    protected SwitchAction() {
        this.setEnabledInModalContext(true);
    }

    @Override
    public void update(AnActionEvent e) {
        if (!SwitchAction.getSettings().isEnabled()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        SwitchingSession session = SwitchAction.getSession(e);
        e.getPresentation().setEnabled(session != null && !session.isFinished() || SwitchAction.getProvider(e) != null);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        SwitchingSession session = SwitchAction.getSession(e);
        if (session == null || session.isFinished()) {
            SwitchProvider provider = SwitchAction.getProvider(e);
            session = new SwitchingSession(SwitchAction.getManager(e), provider, (KeyEvent)e.getInputEvent(), null, false);
            SwitchAction.initSession(e, session);
        }
        this.move(session);
    }

    protected static QuickAccessSettings getSettings() {
        return QuickAccessSettings.getInstance();
    }

    private static SwitchProvider getProvider(AnActionEvent e) {
        return e.getData(SwitchProvider.KEY);
    }

    private static SwitchingSession getSession(AnActionEvent e) {
        return SwitchAction.getManager(e).getSession();
    }

    private static SwitchManager getManager(AnActionEvent e) {
        Project project = CommonDataKeys.PROJECT.getData(e.getDataContext());
        return SwitchManager.getInstance(project);
    }

    private static void initSession(AnActionEvent e, SwitchingSession session) {
        SwitchAction.getManager(e).initSession(session);
    }

    protected abstract void move(SwitchingSession var1);

    public static class Right
    extends SwitchAction {
        @Override
        protected void move(SwitchingSession session) {
            session.right();
        }
    }

    public static class Left
    extends SwitchAction {
        @Override
        protected void move(SwitchingSession session) {
            session.left();
        }
    }

    public static class Down
    extends SwitchAction {
        @Override
        protected void move(SwitchingSession session) {
            session.down();
        }
    }

    public static class Up
    extends SwitchAction {
        @Override
        protected void move(SwitchingSession session) {
            session.up();
        }
    }
}

