/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.ui.StatusText;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.text.JTextComponent;

class TextComponentEmptyText
extends StatusText {
    private JTextComponent myOwner;

    public TextComponentEmptyText(JTextComponent owner) {
        super(owner);
        this.myOwner = owner;
        this.clear();
        this.myOwner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TextComponentEmptyText.this.myOwner.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextComponentEmptyText.this.myOwner.repaint();
            }
        });
    }

    public void paintStatusText(Graphics g) {
        this.getComponent().setFont(this.myOwner.getFont());
        this.paint(this.myOwner, g);
    }

    @Override
    protected boolean isStatusVisible() {
        return this.myOwner.getText().isEmpty() && !this.myOwner.isFocusOwner();
    }

    @Override
    protected Rectangle getTextComponentBound() {
        Rectangle b = this.myOwner.getBounds();
        return new Rectangle(this.myOwner.getInsets().left >> 1, 0, b.width, b.height);
    }
}

