/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.referencesSearch");
    private static final ReferencesSearch INSTANCE = new ReferencesSearch();

    private ReferencesSearch() {
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        Query<PsiReference> query = ReferencesSearch.search(element, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(element)), false);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        Query<PsiReference> query = ReferencesSearch.search(element, searchScope, false);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        Query<PsiReference> query = ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope));
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        Query<PsiReference> result = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResultsQuery = ReferencesSearch.uniqueResults(result);
            if (uniqueResultsQuery == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
            }
            return uniqueResultsQuery;
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        PsiElement element = parameters.getElementToSearch();
        UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResultsQuery = ReferencesSearch.uniqueResults(new MergeQuery<PsiReference>(result, new SearchRequestQuery(PsiUtilCore.getProjectInReadAction(element), requests)));
        if (uniqueResultsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch", "search"));
        }
        return uniqueResultsQuery;
    }

    @NotNull
    private static UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResults(@NotNull Query<PsiReference> composite) {
        if (composite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "composite", "com/intellij/psi/search/searches/ReferencesSearch", "uniqueResults"));
        }
        UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResultsQuery = new UniqueResultsQuery<PsiReference, ReferenceDescriptor>(composite, ContainerUtil.canonicalStrategy(), ReferenceDescriptor.MAPPER);
        if (uniqueResultsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch", "uniqueResults"));
        }
        return uniqueResultsQuery;
    }

    public static void searchOptimized(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope, @NotNull SearchRequestCollector collector, final @NotNull Processor<PsiReference> processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/searches/ReferencesSearch", "searchOptimized"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/searches/ReferencesSearch", "searchOptimized"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/search/searches/ReferencesSearch", "searchOptimized"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/searches/ReferencesSearch", "searchOptimized"));
        }
        ReferencesSearch.searchOptimized(element, searchScope, ignoreAccessScope, collector, false, new PairProcessor<PsiReference, SearchRequestCollector>(){

            public boolean process(PsiReference psiReference, SearchRequestCollector collector) {
                return processor.process((Object)psiReference);
            }
        });
    }

    public static void searchOptimized(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope, @NotNull SearchRequestCollector collector, boolean inReadAction, @NotNull PairProcessor<PsiReference, SearchRequestCollector> processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/searches/ReferencesSearch", "searchOptimized"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/searches/ReferencesSearch", "searchOptimized"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/search/searches/ReferencesSearch", "searchOptimized"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/searches/ReferencesSearch", "searchOptimized"));
        }
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        Query<PsiReference> query = ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope, nested));
        collector.searchQuery(new QuerySearchRequest(query, nested, inReadAction, processor));
    }

    public static class SearchParameters {
        private final PsiElement myElementToSearch;
        private final SearchScope myScope;
        private final boolean myIgnoreAccessScope;
        private final SearchRequestCollector myOptimizer;
        private final boolean isSharedOptimizer;

        public SearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope, boolean ignoreAccessScope, @Nullable SearchRequestCollector optimizer) {
            if (elementToSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToSearch", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "<init>"));
            }
            this.myElementToSearch = elementToSearch;
            this.myScope = scope;
            this.myIgnoreAccessScope = ignoreAccessScope;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer == null ? new SearchRequestCollector(new SearchSession()) : optimizer;
        }

        public SearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope, boolean ignoreAccessScope) {
            if (elementToSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToSearch", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "<init>"));
            }
            this(elementToSearch, scope, ignoreAccessScope, null);
        }

        @NotNull
        public PsiElement getElementToSearch() {
            PsiElement psiElement = this.myElementToSearch;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "getElementToSearch"));
            }
            return psiElement;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated
        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "getScope"));
            }
            return searchScope;
        }

        public boolean isIgnoreAccessScope() {
            return this.myIgnoreAccessScope;
        }

        @NotNull
        public SearchRequestCollector getOptimizer() {
            SearchRequestCollector searchRequestCollector = this.myOptimizer;
            if (searchRequestCollector == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "getOptimizer"));
            }
            return searchRequestCollector;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            if (this.myIgnoreAccessScope) {
                SearchScope searchScope = this.myScope;
                if (searchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "getEffectiveSearchScope"));
                }
                return searchScope;
            }
            SearchScope accessScope = PsiSearchHelper.SERVICE.getInstance(this.myElementToSearch.getProject()).getUseScope(this.myElementToSearch);
            SearchScope searchScope = this.myScope.intersectWith(accessScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters", "getEffectiveSearchScope"));
            }
            return searchScope;
        }
    }
}

