/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionDetector {
    private final Document myDocument;
    private final ArrangementSettings mySettings;
    private final Consumer<ArrangementSectionEntryTemplate> mySectionEntryProducer;
    private final Stack<ArrangementSectionRule> myOpenedSections;

    public ArrangementSectionDetector(@Nullable Document document, @NotNull ArrangementSettings settings, @NotNull Consumer<ArrangementSectionEntryTemplate> producer) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector", "<init>"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector", "<init>"));
        }
        this.myOpenedSections = ContainerUtil.newStack();
        this.myDocument = document;
        this.mySettings = settings;
        this.mySectionEntryProducer = producer;
    }

    public boolean processComment(@NotNull PsiComment comment) {
        ArrangementSectionRule lastSection;
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector", "processComment"));
        }
        TextRange range = comment.getTextRange();
        TextRange expandedRange = this.myDocument == null ? range : ArrangementUtil.expandToLineIfPossible(range, this.myDocument);
        TextRange sectionTextRange = new TextRange(expandedRange.getStartOffset(), expandedRange.getEndOffset());
        String commentText = comment.getText().trim();
        ArrangementSectionRule openSectionRule = ArrangementSectionDetector.isSectionStartComment(this.mySettings, commentText);
        if (openSectionRule != null) {
            this.mySectionEntryProducer.consume((Object)new ArrangementSectionEntryTemplate(comment, StdArrangementTokens.Section.START_SECTION, sectionTextRange, commentText));
            this.myOpenedSections.push((Object)openSectionRule);
            return true;
        }
        if (!this.myOpenedSections.isEmpty() && (lastSection = (ArrangementSectionRule)this.myOpenedSections.peek()).getEndComment() != null && StringUtil.equals((CharSequence)commentText, (CharSequence)lastSection.getEndComment())) {
            this.mySectionEntryProducer.consume((Object)new ArrangementSectionEntryTemplate(comment, StdArrangementTokens.Section.END_SECTION, sectionTextRange, commentText));
            this.myOpenedSections.pop();
            return true;
        }
        return false;
    }

    @Nullable
    public static ArrangementSectionRule isSectionStartComment(@NotNull ArrangementSettings settings, @NotNull String comment) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector", "isSectionStartComment"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector", "isSectionStartComment"));
        }
        for (ArrangementSectionRule rule : settings.getSections()) {
            if (rule.getStartComment() == null || !StringUtil.equals((CharSequence)comment, (CharSequence)rule.getStartComment())) continue;
            return rule;
        }
        return null;
    }

    public static class ArrangementSectionEntryTemplate {
        private PsiElement myElement;
        private ArrangementSettingsToken myToken;
        private TextRange myTextRange;
        private String myText;

        public ArrangementSectionEntryTemplate(@NotNull PsiElement element, @NotNull ArrangementSettingsToken token, @NotNull TextRange range, @NotNull String text) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector$ArrangementSectionEntryTemplate", "<init>"));
            }
            if (token == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector$ArrangementSectionEntryTemplate", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector$ArrangementSectionEntryTemplate", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector$ArrangementSectionEntryTemplate", "<init>"));
            }
            this.myElement = element;
            this.myToken = token;
            this.myTextRange = range;
            this.myText = text;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public ArrangementSettingsToken getToken() {
            return this.myToken;
        }

        public TextRange getTextRange() {
            return this.myTextRange;
        }

        public String getText() {
            return this.myText;
        }
    }
}

