/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FixedSizeButton
extends JButton {
    private int mySize;
    private JComponent myComponent;

    public FixedSizeButton() {
        this(-1, null);
    }

    private FixedSizeButton(int size, JComponent component) {
        Icon icon = AllIcons.General.Ellipsis;
        if (icon != null) {
            this.setIcon(icon);
        } else {
            this.setText(".");
        }
        this.mySize = size;
        this.myComponent = component;
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setDefaultCapable(false);
        this.setFocusable(false);
        if (UIUtil.isUnderAquaLookAndFeel() && size == -1 || UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula()) {
            this.putClientProperty("JButton.buttonType", "square");
        }
    }

    public FixedSizeButton(int size) {
        this(size, null);
        if (size <= 0) {
            throw new IllegalArgumentException("wrong size: " + size);
        }
    }

    public FixedSizeButton(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/FixedSizeButton", "<init>"));
        }
        this(-1, component);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myComponent != null) {
            int size = this.myComponent.getPreferredSize().height;
            if (this.myComponent instanceof JComboBox && (UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula())) {
                size -= 2;
            }
            return new Dimension(size, size);
        }
        if (this.mySize != -1) {
            return new Dimension(this.mySize, this.mySize);
        }
        return super.getPreferredSize();
    }

    public void setAttachedComponent(JComponent component) {
        this.myComponent = component;
    }

    public JComponent getAttachedComponent() {
        return this.myComponent;
    }

    public void setSize(int size) {
        this.mySize = size;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int size = Math.min(width, height);
        super.setBounds(x, y, size, size);
    }

    @Override
    public void setBounds(Rectangle r) {
        if (r.width != r.height) {
            int size = Math.min(r.width, r.height);
            r = new Rectangle(r.x, r.y, size, size);
        }
        super.setBounds(r);
    }
}

