/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffRequest
extends DiffRequest {
    private final DiffContent[] myContents = new DiffContent[2];
    private final String[] myContentTitles = new String[2];
    private String myWindowTitle;

    public SimpleDiffRequest(Project project, String windowTitle) {
        super(project);
        this.myWindowTitle = windowTitle;
    }

    @Override
    @NotNull
    public DiffContent[] getContents() {
        if (this.myContents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/SimpleDiffRequest", "getContents"));
        }
        return this.myContents;
    }

    @Override
    public String[] getContentTitles() {
        return this.myContentTitles;
    }

    @Override
    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    public void setContents(@NotNull DiffContent content1, @NotNull DiffContent content2) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/openapi/diff/SimpleDiffRequest", "setContents"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/openapi/diff/SimpleDiffRequest", "setContents"));
        }
        this.myContents[0] = content1;
        this.myContents[1] = content2;
    }

    public void setContentTitles(String title1, String title2) {
        this.myContentTitles[0] = title1;
        this.myContentTitles[1] = title2;
    }

    @Override
    public void setWindowTitle(String windowTitle) {
        this.myWindowTitle = windowTitle;
    }

    public static SimpleDiffRequest compareFiles(VirtualFile file1, VirtualFile file2, Project project, String title) {
        FileDiffRequest result = new FileDiffRequest(project, title);
        ((FileDiffRequest)result).myVirtualFiles[0] = file1;
        ((FileDiffRequest)result).myVirtualFiles[1] = file2;
        ((FileDiffRequest)result).myContentTitles[0] = DiffContentUtil.getTitle(file1);
        ((FileDiffRequest)result).myContentTitles[1] = DiffContentUtil.getTitle(file2);
        return result;
    }

    public static SimpleDiffRequest compareFiles(@NotNull VirtualFile file1, @NotNull VirtualFile file2, @NotNull Project project) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/diff/SimpleDiffRequest", "compareFiles"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/diff/SimpleDiffRequest", "compareFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/SimpleDiffRequest", "compareFiles"));
        }
        String title = DiffBundle.message("compare.file.vs.file.dialog.title", file1.getPresentableUrl(), file2.getPresentableUrl());
        return SimpleDiffRequest.compareFiles(file1, file2, project, title);
    }

    private static class FileDiffRequest
    extends SimpleDiffRequest {
        private final String[] myContentTitles = new String[2];
        private final VirtualFile[] myVirtualFiles = new VirtualFile[2];

        public FileDiffRequest(Project project, String title) {
            super(project, title);
        }

        @Override
        @NotNull
        public DiffContent[] getContents() {
            DiffContent[] diffContentArray = new DiffContent[]{DiffContent.fromFile(this.getProject(), this.myVirtualFiles[0]), DiffContent.fromFile(this.getProject(), this.myVirtualFiles[1])};
            if (diffContentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/SimpleDiffRequest$FileDiffRequest", "getContents"));
            }
            return diffContentArray;
        }

        @Override
        public String[] getContentTitles() {
            return this.myContentTitles;
        }
    }
}

