/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class DiffContent {
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myIsEmpty;

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    protected void fireContentInvalid() {
        for (Listener listener : this.myListeners) {
            listener.contentInvalid();
        }
    }

    public boolean isBinary() {
        return false;
    }

    public void setIsEmpty(boolean isEmpty) {
        this.myIsEmpty = isEmpty;
    }

    public boolean isEmpty() {
        return this.myIsEmpty;
    }

    public void onAssigned(boolean isAssigned) {
    }

    public abstract Document getDocument();

    public abstract OpenFileDescriptor getOpenFileDescriptor(int var1);

    @Nullable
    public abstract VirtualFile getFile();

    @Nullable
    public abstract FileType getContentType();

    public abstract byte[] getBytes() throws IOException;

    public static FileContent fromFile(Project project, VirtualFile file) {
        return file != null ? new FileContent(project, file) : null;
    }

    public static DocumentContent fromDocument(Project project, Document document) {
        return new DocumentContent(project, document);
    }

    @Nullable
    public LineSeparator getLineSeparator() {
        return null;
    }

    public static interface Listener {
        public void contentInvalid();
    }
}

