/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import org.jetbrains.annotations.NotNull;

public abstract class BaseActionRunnable<T> {
    private boolean mySilentExecution;

    public boolean isSilentExecution() {
        return this.mySilentExecution;
    }

    protected abstract void run(@NotNull Result<T> var1) throws Throwable;

    @NotNull
    public abstract RunResult<T> execute();

    protected boolean canWriteNow() {
        return this.getApplication().isWriteAccessAllowed();
    }

    protected boolean canReadNow() {
        return this.getApplication().isReadAccessAllowed();
    }

    protected Application getApplication() {
        return ApplicationManager.getApplication();
    }

    @NotNull
    public final RunResult<T> executeSilently() {
        this.mySilentExecution = true;
        RunResult<T> runResult = this.execute();
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/BaseActionRunnable", "executeSilently"));
        }
        return runResult;
    }
}

