/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public interface NotificationListener {
    public static final NotificationListener URL_OPENING_LISTENER = new UrlOpeningListener(true);

    public void hyperlinkUpdate(@NotNull Notification var1, @NotNull HyperlinkEvent var2);

    public static class UrlOpeningListener
    extends Adapter {
        private final boolean myExpireNotification;

        public UrlOpeningListener(boolean expireNotification) {
            this.myExpireNotification = expireNotification;
        }

        @Override
        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/NotificationListener$UrlOpeningListener", "hyperlinkActivated"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/NotificationListener$UrlOpeningListener", "hyperlinkActivated"));
            }
            URL url = event.getURL();
            if (url == null) {
                BrowserUtil.browse(event.getDescription());
            } else {
                BrowserUtil.browse(url);
            }
            if (this.myExpireNotification) {
                notification.expire();
            }
        }
    }

    public static abstract class Adapter
    implements NotificationListener {
        @Override
        public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/NotificationListener$Adapter", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/NotificationListener$Adapter", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.hyperlinkActivated(notification, event);
            }
        }

        protected abstract void hyperlinkActivated(@NotNull Notification var1, @NotNull HyperlinkEvent var2);
    }
}

