/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectBuilder {
    public boolean isUpdate() {
        return false;
    }

    @Nullable
    public abstract List<Module> commit(@NotNull Project var1, @Nullable ModifiableModuleModel var2, ModulesProvider var3);

    public List<Module> commit(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/projectWizard/ProjectBuilder", "commit"));
        }
        return this.commit(project, null, DefaultModulesProvider.createForProject(project));
    }

    public boolean validate(Project current, Project dest) {
        return true;
    }

    public void cleanup() {
    }

    public boolean isOpenProjectSettingsAfter() {
        return false;
    }

    @Deprecated
    public boolean isSuitableSdk(Sdk sdk) {
        return this.isSuitableSdkType(sdk.getSdkType());
    }

    public boolean isSuitableSdkType(SdkTypeId sdkType) {
        return true;
    }

    @Nullable
    public Project createProject(String name, String path) {
        return ProjectManager.getInstance().createProject(name, path);
    }
}

