/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationProducer<T extends RunConfiguration> {
    public static final ExtensionPointName<RunConfigurationProducer> EP_NAME = ExtensionPointName.create((String)"com.intellij.runConfigurationProducer");
    private final ConfigurationFactory myConfigurationFactory;

    protected RunConfigurationProducer(ConfigurationFactory configurationFactory) {
        this.myConfigurationFactory = configurationFactory;
    }

    protected RunConfigurationProducer(ConfigurationType configurationType) {
        this.myConfigurationFactory = configurationType.getConfigurationFactories()[0];
    }

    public ConfigurationFactory getConfigurationFactory() {
        return this.myConfigurationFactory;
    }

    public ConfigurationType getConfigurationType() {
        return this.myConfigurationFactory.getType();
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(ConfigurationContext context) {
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        Ref locationRef = new Ref((Object)context.getPsiLocation());
        if (!this.setupConfigurationFromContext(settings.getConfiguration(), context, (Ref<PsiElement>)locationRef)) {
            return null;
        }
        return new ConfigurationFromContextImpl(this, settings, (PsiElement)locationRef.get());
    }

    protected abstract boolean setupConfigurationFromContext(T var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public abstract boolean isConfigurationFromContext(T var1, ConfigurationContext var2);

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    public void onFirstRun(ConfigurationFromContext configuration, ConfigurationContext context, Runnable startRunnable) {
        startRunnable.run();
    }

    @Nullable
    public ConfigurationFromContext findOrCreateConfigurationFromContext(ConfigurationContext context) {
        PsiElement psiElement;
        Location<PsiElement> _location;
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        ConfigurationFromContext fromContext = this.createConfigurationFromContext(context);
        if (fromContext != null && (_location = PsiLocation.fromPsiElement(psiElement = fromContext.getSourceElement(), location.getModule())) != null) {
            RunManager runManager = RunManager.getInstance(context.getProject());
            ConfigurationType type = fromContext.getConfigurationType();
            List<RunnerAndConfigurationSettings> configurations = runManager.getConfigurationSettingsList(type);
            RunnerAndConfigurationSettings settings = this.findExistingConfiguration(context);
            if (settings != null) {
                fromContext.setConfigurationSettings(settings);
            } else {
                ArrayList<String> currentNames = new ArrayList<String>();
                for (RunnerAndConfigurationSettings configurationSettings : configurations) {
                    currentNames.add(configurationSettings.getName());
                }
                RunConfiguration configuration = fromContext.getConfiguration();
                String name = configuration.getName();
                assert (name != null) : configuration;
                configuration.setName(RunManager.suggestUniqueName(name, currentNames));
            }
        }
        return fromContext;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(ConfigurationContext context) {
        RunManager runManager = RunManager.getInstance(context.getProject());
        List<RunnerAndConfigurationSettings> configurations = runManager.getConfigurationSettingsList(this.myConfigurationFactory.getType());
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            if (!this.isConfigurationFromContext(configurationSettings.getConfiguration(), context)) continue;
            return configurationSettings;
        }
        return null;
    }

    protected RunnerAndConfigurationSettings cloneTemplateConfiguration(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/RunConfigurationProducer", "cloneTemplateConfiguration"));
        }
        RunConfiguration original = context.getOriginalConfiguration(this.myConfigurationFactory.getType());
        if (original != null) {
            return RunManager.getInstance(context.getProject()).createConfiguration(original.clone(), this.myConfigurationFactory);
        }
        return RunManager.getInstance(context.getProject()).createRunConfiguration("", this.myConfigurationFactory);
    }

    public static RunConfigurationProducer getInstance(Class<? extends RunConfigurationProducer> aClass) {
        for (RunConfigurationProducer producer : (RunConfigurationProducer[])Extensions.getExtensions(EP_NAME)) {
            if (!aClass.isInstance(producer)) continue;
            return producer;
        }
        return null;
    }
}

