/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Location;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class PsiLocation<E extends PsiElement>
extends Location<E> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.PsiLocation");
    private final E myPsiElement;
    private final Project myProject;
    private final Module myModule;

    public PsiLocation(@NotNull Project project, @NotNull E psiElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/PsiLocation", "<init>"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/execution/PsiLocation", "<init>"));
        }
        this.myPsiElement = psiElement;
        this.myProject = project;
        this.myModule = ModuleUtil.findModuleForPsiElement(psiElement);
    }

    public PsiLocation(@NotNull Project project, Module module, @NotNull E psiElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/PsiLocation", "<init>"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/execution/PsiLocation", "<init>"));
        }
        this.myPsiElement = psiElement;
        this.myProject = project;
        this.myModule = module;
    }

    @Override
    @NotNull
    public E getPsiElement() {
        E e = this.myPsiElement;
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/PsiLocation", "getPsiElement"));
        }
        return e;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/PsiLocation", "getProject"));
        }
        return project;
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }

    @Override
    @NotNull
    public <T extends PsiElement> Iterator<Location<T>> getAncestors(@NotNull Class<T> ancestorClass, boolean strict) {
        if (ancestorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestorClass", "com/intellij/execution/PsiLocation", "getAncestors"));
        }
        T first = strict || !ancestorClass.isInstance(this.myPsiElement) ? PsiLocation.findNext(this.myPsiElement, ancestorClass) : this.myPsiElement;
        Iterator iterator = new Iterator<Location<T>>((PsiElement)first, ancestorClass){
            private T myCurrent;
            final /* synthetic */ PsiElement val$first;
            final /* synthetic */ Class val$ancestorClass;
            {
                this.val$first = psiElement;
                this.val$ancestorClass = clazz;
                this.myCurrent = this.val$first;
            }

            @Override
            public boolean hasNext() {
                return this.myCurrent != null;
            }

            @Override
            public Location<T> next() {
                if (this.myCurrent == null) {
                    throw new NoSuchElementException();
                }
                PsiLocation psiLocation = new PsiLocation(PsiLocation.this.myProject, this.myCurrent);
                this.myCurrent = PsiLocation.findNext(this.myCurrent, this.val$ancestorClass);
                return psiLocation;
            }

            @Override
            public void remove() {
                LOG.assertTrue(false);
            }
        };
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/PsiLocation", "getAncestors"));
        }
        return iterator;
    }

    @Override
    @NotNull
    public PsiLocation<E> toPsiLocation() {
        PsiLocation psiLocation = this;
        if (psiLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/PsiLocation", "toPsiLocation"));
        }
        return psiLocation;
    }

    private static <ElementClass extends PsiElement> ElementClass findNext(PsiElement psiElement, Class<ElementClass> ancestorClass) {
        PsiElement element = psiElement;
        while ((element = element.getParent()) != null && !(element instanceof PsiFile)) {
            PsiElement ancestor = (PsiElement)PsiLocation.safeCast(element, ancestorClass);
            if (ancestor == null) continue;
            return (ElementClass)ancestor;
        }
        return null;
    }

    public static <T extends PsiElement> Location<T> fromPsiElement(@NotNull Project project, T element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/PsiLocation", "fromPsiElement"));
        }
        if (element == null) {
            return null;
        }
        return new PsiLocation<T>(project, element);
    }

    public static <T extends PsiElement> Location<T> fromPsiElement(T element) {
        return PsiLocation.fromPsiElement(element, null);
    }

    public static <T extends PsiElement> Location<T> fromPsiElement(T element, Module module) {
        if (element == null || !element.isValid()) {
            return null;
        }
        return module != null ? new PsiLocation<T>(element.getProject(), module, element) : new PsiLocation<T>(element.getProject(), element);
    }
}

