/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.util.Couple;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Side
extends Enum<Side> {
    public static final /* enum */ Side LEFT = new Side(0);
    public static final /* enum */ Side RIGHT = new Side(1);
    private final int myIndex;
    private static final /* synthetic */ Side[] $VALUES;

    public static Side[] values() {
        return (Side[])$VALUES.clone();
    }

    public static Side valueOf(String name) {
        return Enum.valueOf(Side.class, name);
    }

    private Side(int index) {
        this.myIndex = index;
    }

    @NotNull
    public static Side fromLeft(boolean isLeft) {
        Side side = isLeft ? LEFT : RIGHT;
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/Side", "fromLeft"));
        }
        return side;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public boolean isLeft() {
        return this.myIndex == 0;
    }

    @NotNull
    public Side other() {
        Side side = this.isLeft() ? RIGHT : LEFT;
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/Side", "other"));
        }
        return side;
    }

    @NotNull
    public Side other(boolean other) {
        Side side = other ? this.other() : this;
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/Side", "other"));
        }
        return side;
    }

    public int select(int left, int right) {
        return this.isLeft() ? left : right;
    }

    @Nullable
    @Contract(value="!null, !null -> !null; null, null -> null")
    public <T> T select(@Nullable T left, @Nullable T right) {
        return this.isLeft() ? left : right;
    }

    @NotNull
    public <T> T selectNotNull(@NotNull T left, @NotNull T right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        T t = this.isLeft() ? left : right;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        return t;
    }

    public int select(@NotNull int[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/diff/util/Side", "select"));
        }
        assert (array.length == 2);
        return array[this.myIndex];
    }

    public <T> T select(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/diff/util/Side", "select"));
        }
        assert (array.length == 2);
        return array[this.myIndex];
    }

    @NotNull
    public <T> T selectNotNull(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        assert (array.length == 2);
        T t = array[this.myIndex];
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        return t;
    }

    public <T> T select(@NotNull List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/diff/util/Side", "select"));
        }
        assert (list.size() == 2);
        return list.get(this.myIndex);
    }

    @NotNull
    public <T> T selectNotNull(@NotNull List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        assert (list.size() == 2);
        T t = list.get(this.myIndex);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        return t;
    }

    public <T> T select(@NotNull Couple<T> region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/util/Side", "select"));
        }
        return (T)(this.isLeft() ? region.first : region.second);
    }

    @NotNull
    public <T> T selectNotNull(@NotNull Couple<T> region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        Object object = this.isLeft() ? region.first : region.second;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/Side", "selectNotNull"));
        }
        return (T)object;
    }

    public int getStartOffset(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/Side", "getStartOffset"));
        }
        return this.isLeft() ? fragment.getStartOffset1() : fragment.getStartOffset2();
    }

    public int getEndOffset(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/Side", "getEndOffset"));
        }
        return this.isLeft() ? fragment.getEndOffset1() : fragment.getEndOffset2();
    }

    public int getStartLine(@NotNull LineFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/Side", "getStartLine"));
        }
        return this.isLeft() ? fragment.getStartLine1() : fragment.getStartLine2();
    }

    public int getEndLine(@NotNull LineFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/Side", "getEndLine"));
        }
        return this.isLeft() ? fragment.getEndLine1() : fragment.getEndLine2();
    }

    static {
        $VALUES = new Side[]{LEFT, RIGHT};
    }
}

