/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Chunk;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public final class ModuleCompilerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.ModuleCompilerUtil");

    private ModuleCompilerUtil() {
    }

    public static Module[] getDependencies(Module module) {
        return ModuleRootManager.getInstance(module).getDependencies();
    }

    public static Graph<Module> createModuleGraph(final Module[] modules) {
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Module>(){

            public Collection<Module> getNodes() {
                return Arrays.asList(modules);
            }

            public Iterator<Module> getIn(Module module) {
                return Arrays.asList(ModuleCompilerUtil.getDependencies(module)).iterator();
            }
        }));
    }

    public static List<Chunk<Module>> getSortedModuleChunks(Project project, List<Module> modules) {
        Module[] allModules = ModuleManager.getInstance(project).getModules();
        List<Chunk<Module>> chunks = ModuleCompilerUtil.getSortedChunks(ModuleCompilerUtil.createModuleGraph(allModules));
        HashSet<Module> modulesSet = new HashSet<Module>(modules);
        Iterator<Chunk<Module>> it = chunks.iterator();
        while (it.hasNext()) {
            Chunk<Module> chunk = it.next();
            if (ContainerUtil.intersects((Collection)chunk.getNodes(), modulesSet)) continue;
            it.remove();
        }
        return chunks;
    }

    public static <Node> List<Chunk<Node>> getSortedChunks(Graph<Node> graph) {
        Graph<Chunk<Node>> chunkGraph = ModuleCompilerUtil.toChunkGraph(graph);
        ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(chunkGraph.getNodes().size());
        for (Chunk chunk : chunkGraph.getNodes()) {
            chunks.add(chunk);
        }
        DFSTBuilder builder = new DFSTBuilder(chunkGraph);
        if (!builder.isAcyclic()) {
            LOG.error("Acyclic graph expected");
            return null;
        }
        Collections.sort(chunks, builder.comparator());
        return chunks;
    }

    public static <Node> Graph<Chunk<Node>> toChunkGraph(Graph<Node> graph) {
        return GraphAlgorithms.getInstance().computeSCCGraph(graph);
    }

    public static void sortModules(final Project project, final List<Module> modules) {
        Application application = ApplicationManager.getApplication();
        Runnable sort = new Runnable(){

            @Override
            public void run() {
                Comparator<Module> comparator = ModuleManager.getInstance(project).moduleDependencyComparator();
                Collections.sort(modules, comparator);
            }
        };
        if (application.isDispatchThread()) {
            sort.run();
        } else {
            application.runReadAction(sort);
        }
    }

    public static <T extends ModuleRootModel> GraphGenerator<T> createGraphGenerator(final Map<Module, T> models) {
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<T>(){

            public Collection<T> getNodes() {
                return models.values();
            }

            public Iterator<T> getIn(ModuleRootModel model) {
                final ArrayList dependencies = new ArrayList();
                model.orderEntries().compileOnly().forEachModule(new Processor<Module>(){

                    public boolean process(Module module) {
                        ModuleRootModel depModel = (ModuleRootModel)models.get(module);
                        if (depModel != null) {
                            dependencies.add(depModel);
                        }
                        return true;
                    }
                });
                return dependencies.iterator();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Couple<Module> addingDependencyFormsCircularity(Module currentModule, Module toDependOn) {
        assert (currentModule != toDependOn);
        LinkedHashMap<Module, ModifiableRootModel> models = new LinkedHashMap<Module, ModifiableRootModel>();
        Project project = currentModule.getProject();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            ModifiableRootModel model = ModuleRootManager.getInstance(module).getModifiableModel();
            models.put(module, model);
        }
        ModifiableRootModel currentModel = (ModifiableRootModel)models.get(currentModule);
        ModifiableRootModel toDependOnModel = (ModifiableRootModel)models.get(toDependOn);
        Collection nodesBefore = ModuleCompilerUtil.buildChunks(models);
        for (Chunk chunk : nodesBefore) {
            if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
            return null;
        }
        try {
            currentModel.addModuleOrderEntry(toDependOn);
            Collection nodesAfter = ModuleCompilerUtil.buildChunks(models);
            for (Chunk chunk : nodesAfter) {
                if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
                Iterator nodes = chunk.getNodes().iterator();
                Couple couple = Couple.of((Object)((ModifiableRootModel)nodes.next()).getModule(), (Object)((ModifiableRootModel)nodes.next()).getModule());
                return couple;
            }
        }
        finally {
            for (ModifiableRootModel model : models.values()) {
                model.dispose();
            }
        }
        return null;
    }

    public static <T extends ModuleRootModel> Collection<Chunk<T>> buildChunks(Map<Module, T> models) {
        return ModuleCompilerUtil.toChunkGraph(ModuleCompilerUtil.createGraphGenerator(models)).getNodes();
    }

    public static List<Chunk<ModuleSourceSet>> getCyclicDependencies(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/ModuleCompilerUtil", "getCyclicDependencies"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/compiler/ModuleCompilerUtil", "getCyclicDependencies"));
        }
        Graph<ModuleSourceSet> graph = ModuleCompilerUtil.createModuleSourceDependenciesGraph(new DefaultModulesProvider(project));
        Collection<Chunk<ModuleSourceSet>> chunks = GraphAlgorithms.getInstance().computeStronglyConnectedComponents(graph);
        final HashSet<Module> modulesSet = new HashSet<Module>(modules);
        return ContainerUtil.filter(chunks, (Condition)new Condition<Chunk<ModuleSourceSet>>(){

            public boolean value(Chunk<ModuleSourceSet> chunk) {
                for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                    if (!modulesSet.contains(sourceSet.getModule())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static Graph<ModuleSourceSet> createModuleSourceDependenciesGraph(final RootModelProvider provider) {
        return GraphGenerator.create((GraphGenerator.SemiGraph)new CachingSemiGraph((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<ModuleSourceSet>(){

            public Collection<ModuleSourceSet> getNodes() {
                Module[] modules = provider.getModules();
                ArrayList<ModuleSourceSet> result = new ArrayList<ModuleSourceSet>(modules.length * 2);
                for (Module module : modules) {
                    ModuleCompilerUtil.addSourceSetIfAny(result, module, ModuleSourceSet.Type.PRODUCTION, provider);
                    ModuleCompilerUtil.addSourceSetIfAny(result, module, ModuleSourceSet.Type.TEST, provider);
                }
                return result;
            }

            public Iterator<ModuleSourceSet> getIn(final ModuleSourceSet n) {
                ModuleRootModel model = provider.getRootModel(n.getModule());
                OrderEnumerator enumerator = model.orderEntries().compileOnly();
                if (n.getType() == ModuleSourceSet.Type.PRODUCTION) {
                    enumerator = enumerator.productionOnly();
                }
                final ArrayList deps = new ArrayList();
                enumerator.forEachModule(new Processor<Module>(){

                    public boolean process(Module module) {
                        ModuleCompilerUtil.addSourceSetIfAny(deps, module, n.getType(), provider);
                        return true;
                    }
                });
                if (n.getType() == ModuleSourceSet.Type.TEST) {
                    ModuleCompilerUtil.addSourceSetIfAny(deps, n.getModule(), ModuleSourceSet.Type.PRODUCTION, provider);
                }
                return deps.iterator();
            }
        }));
    }

    private static void addSourceSetIfAny(List<ModuleSourceSet> result, Module module, ModuleSourceSet.Type type, RootModelProvider provider) {
        JavaSourceRootType rootType;
        JavaSourceRootType javaSourceRootType = rootType = type == ModuleSourceSet.Type.PRODUCTION ? JavaSourceRootType.SOURCE : JavaSourceRootType.TEST_SOURCE;
        if (!provider.getRootModel(module).getSourceRoots(rootType).isEmpty()) {
            result.add(new ModuleSourceSet(module, type));
        }
    }
}

