/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.generation.actions.GenerateActionPopupTemplateInjector;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseGenerateAction
extends CodeInsightAction
implements GenerateActionPopupTemplateInjector {
    private final CodeInsightActionHandler myHandler;

    public BaseGenerateAction(CodeInsightActionHandler handler) {
        this.myHandler = handler;
    }

    @Override
    @Nullable
    public AnAction createEditTemplateAction(DataContext dataContext) {
        return null;
    }

    @Override
    @NotNull
    protected final CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = this.myHandler;
        if (codeInsightActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/actions/BaseGenerateAction", "getHandler"));
        }
        return codeInsightActionHandler;
    }

    @Nullable
    protected PsiClass getTargetClass(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass target = PsiTreeUtil.getParentOfType(element, PsiClass.class);
        return target instanceof SyntheticElement ? null : target;
    }

    @Override
    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/BaseGenerateAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/BaseGenerateAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/BaseGenerateAction", "isValidForFile"));
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        PsiClass targetClass = this.getTargetClass(editor, file);
        return targetClass != null && this.isValidForClass(targetClass);
    }

    protected boolean isValidForClass(PsiClass targetClass) {
        return !targetClass.isInterface();
    }
}

